#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_JackWater.h"
#include "CS_JackDrown.h"
#include "CS_JackControl.h"
#include "CS_JackResist.h"
#include "CS_JackJump.h"
#include "CS_JackStand.h"
#include "CS_JackMove.h"
#include "CS_JackAir.h"
#include "CS_JackFaceToBack.h"
#include "CS_JackHurt.h"
#include "CS_JackBubbler.h"
#include "CS_JackCatcher.h"
#include "CS_JackLevelReset.h"
#define CS_JACK_CREATENAME L"CS_mychar_jack"
//ҽɫ ܿ
class CS_Jack :
	public MyCharEntity
{
public:
	CS_Jack();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	void GetAnimateOffset(float& outDx, float& outDy) override;//ȡƫ
	//ͼʾ
	bool showGun = false;//ʾǹ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_JackWater stateWater;
	CS_JackDrown stateDrown;
	CS_JackControl stateControl;
	CS_JackResist stateResist;
	CS_JackJump stateJump;
	CS_JackStand stateStand;
	CS_JackMove stateMove;
	CS_JackAir stateAir;
	CS_JackFaceToBack stateFaceToBack;
	CS_JackHurt stateHurt;
	//ģ
	CS_JackBubbler skillBubbler;
	CS_JackCatcher skillCatcher;
	CS_JackLevelReset skillLevelReset;
	//
	std::wstring crushEvent;
private:
	void AnimateStep();//
};

std::shared_ptr<Entity> CreateCS_Jack();