#include "CS_HealthRefill.h"

CS_HealthRefill::CS_HealthRefill()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_healthrefill";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	act_no = 1;
	drawBeforeOtherEntity = true;
}

void CS_HealthRefill::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_HealthRefill::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	int a = 0;
	switch (act_no)
	{
	case 1:
		a = Random(0, 30);

		if (a < 10)
			act_no = 2;
		else if (a < 25)
			act_no = 3;
		else
			act_no = 4;

		act_wait = Random(0x10, 0x40);
		ani_wait = 0;
		break;
	case 2:
		ani.image_index = 0;
		if (--act_wait == 0)
			act_no = 1;

		break;

	case 3:
		if (++ani_wait % 2)
			ani.image_index = 0;
		else
			ani.image_index = 1;

		if (--act_wait == 0)
			act_no = 1;

		break;
	case 4:
		ani.image_index = 1;
		if (--act_wait == 0)
			act_no = 1;

		break;
	}
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

std::shared_ptr<Entity> CreateCS_HealthRefill()
{
	return std::make_shared<CS_HealthRefill>();
}
