#include "CS_Fish.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeWaterDrop.h"
CS_Fish::CS_Fish()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.fullWaterBlock = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 2;
	dropExp = 0;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ignoreTrap = true;
}

void CS_Fish::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Fish::Step()
{
	if (bCaught)
	{
		vx = vy = 0;
		HurtAnimate();
	}
	else
	{
		if (cbRect.inWater)
		{
			cbRect.fullWaterBlock = true;
			drawBeforeOtherEntity = false;
			//ˮˮ
			if (setWaterSplash && cbRect.inWater)
			{
				setWaterSplash = false;
				//ˮ
				SetCS_PeWaterDrop(shared_from_this(), shared_from_this());
				flee_counter = 180;
				downSwim = 120;
			}
			if (flee_counter > 0)
			{
				flee_counter--;
				FleeStep();
				if (flee_counter == 0)
					FleeEnd();
			}
			else
			{
				SwimStep();
			}
		}
		else
		{
			cbRect.fullWaterBlock = false;
			drawBeforeOtherEntity = true;
			setWaterSplash = true;
			//ڵϵ
			stateGravity.Step();
			if (cbRect.cbBottom)
				stateResist.Step();
			HurtAnimate();
		}
	}
	//ٶ
	AnimateSpeedStep();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Fish::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (cbRect.inWater)
	{
		*outDamage = 1;
		auto wdst = dst.lock();
		if (wdst)
		{
			if (wdst->lr == 0)
			{
				*outAngle = 315;
			}
			else
			{
				*outAngle = 225;
			}
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}
}

bool CS_Fish::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (!cbRect.inWater)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
	}	
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<Entity> CS_Fish::BeginCaught(std::weak_ptr<Entity> e)
{
	//ҵͬһ
	if (bCaught)
		return std::weak_ptr<Entity>();
	if (flee_counter > 0)
		return std::weak_ptr<Entity>();
	gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	bCaught = true;
	return shared_from_this();
}

void CS_Fish::EndCaught(std::weak_ptr<Entity> e)
{
	bCaught = false;
	if (hp > 0)
	{
		//ĴӴ
		flee_counter = 180;
		dirChange_counter = Random(20, 40);
	}
}

void CS_Fish::FleeStep()
{
	//Ĵ
	if (dirChange_counter > 0)
	{
		dirChange_counter--;
		if (dirChange_counter == 0)
		{
			//ָһ
			lr = Random(0, 1);
			ud = Random(0, 1) == 0 ? -1 : 1;
			dirChange_counter = Random(20, 40);
		}
	}
	if (downSwim > 0)
		downSwim--;
	if (downSwim > 0)
		ud = 1;
	//Ĵζ
	const float fleeSpeed = 0x400 / ts;
	vx = lr == 0 ? -fleeSpeed : fleeSpeed;
	if (ud == -1)
		vy = -fleeSpeed;
	else
		vy = fleeSpeed;
	//ǽı䷽
	if (cbRect.cbLeft)
		lr = 1;
	else if (cbRect.cbRight)
		lr = 0;
	if (cbRect.cbTop)
		ud = 1;
	else if (cbRect.cbBottom)
		ud = -1;
	//ָӾ״̬
	HurtAnimate();
}

void CS_Fish::FleeEnd()
{
}

void CS_Fish::ResistStep()
{
	const float resist = 0xa0 / ts / 2;
	vx /= 1.05f;
	vy /= 1.05f;
	if (abs(vx) < 0.01f)
		vx = 0;
	if (abs(vy) < 0.01f)
		vy = 0;
}
