#include "CS_ExpCapsule.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_ExpCapsule::CS_ExpCapsule()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_expcapsule";
	drawBeforeOtherEntity = true;
	cbRect.top = 8;
	cbRect.left = cbRect.right = cbRect.bottom = 6;
	hp = 1;
}

void CS_ExpCapsule::Step()
{
	auto& ani_no = ani.image_index;
	if (++ani_wait > 4)
	{
		ani_wait = 0;
		++ani_no;
	}

	if (ani_no > 1)
		ani_no = 0;
}

void CS_ExpCapsule::SetState(int stateID, int lr)
{
	if (el.arg.length())
	{
		ParseInts(el.arg.c_str(), buff);
		if (!buff.empty())
			dropExp = buff.front();
	}
}

bool CS_ExpCapsule::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	//
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_025_funny_explode");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//侭
		SetCS_Exp(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_ExpCapsule()
{
	return std::make_shared<CS_ExpCapsule>();
}
