#include "CS_Exp.h"
#include "CS_Heart.h"
CS_Exp::CS_Exp()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.fullWaterBlock = true;
	isItem = true;
	el.name = CS_EXP_CREATENAME;
	SetSize(0);
}

void CS_Exp::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Exp::Step()
{
	auto& ani_no = ani.image_index;
	if (lFloat)
	{
		if (act_no == 0)
		{
			act_no = 1;
			vy = Random(-0x80, 0x80) / ts;
			vx = Random(0x7F, 0x100) / ts;
		}
		vx -= 8 / ts;
		if (vx < -0x600 / ts)
			vx = -0x600 / ts;
		if (cbRect.cbLeft)
			vx = 0x100 / ts;
		if (cbRect.cbTop)
			vy = 0x40 / ts;
		if (cbRect.cbBottom)
			vy = -0x40 / ts;
	}
	else if (rFloat)
	{
		if (act_no == 0)
		{
			act_no = 1;
			vy = Random(-0x80, 0x80) / ts;
			vx = Random(-0x100, -0x7F) / ts;
		}
		vx += 8 / ts;
		if (vx > 0x600 / ts)
			vx = 0x600 / ts;
		if (cbRect.cbRight)
			vx = -0x100 / ts;
		if (cbRect.cbTop)
			vy = 0x40 / ts;
		if (cbRect.cbBottom)
			vy = -0x40 / ts;
	}
	else
	{
		stateSplash.Step();
		if (act_no == 0)
		{
			// Set state
			act_no = 1;
			ani_no = Random(0, 4);

			// Random speed
			vx = Random(-0x200, 0x200) / ts;
			vy = Random(-0x400, 0) / ts;

			// Random direction (reverse animation or not)
			if (Random(0, 1) != 0)
				direct = 0;
			else
				direct = 2;
		}

		// Gravity
		if (cbRect.inWater)
			vy += 21 / ts;
		else
			vy += 42 / ts;

		// Bounce off walls
		if (cbRect.cbLeft)
			vx = abs(vx);
		if (cbRect.cbRight)
			vx = -abs(vx);

		// Bounce off ceiling
		if (cbRect.cbTop)
			vy = abs(vy);

		// Bounce off floor
		if (cbRect.cbBottom)
		{
			gameFunc->PlaySound(L"CS_045_xp_bounce");
			vy = -0x280 / ts;
			vx = 2 * vx / 3;
		}
		// Limit speed
		if (limit_speed)
		{
			constexpr float limitSpeed = 0x5FF / ts;
			if (vx < -limitSpeed)
				vx = -limitSpeed;
			if (vx > limitSpeed)
				vx = limitSpeed;
			if (vy < -limitSpeed)
				vy = -limitSpeed;
			if (vy > limitSpeed)
				vy = limitSpeed;
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();

	// Animate
	++ani_wait;

	if (direct == 0)
	{
		if (ani_wait > 2)
		{
			ani_wait = 0;
			if (++ani_no > 5)
				ani_no = 0;
		}
	}
	else
	{
		if (ani_wait > 2)
		{
			ani_wait = 0;
			if (--ani_no < 0)
				ani_no = 5;
		}
	}

	ani.png = L"CS_CaveStoryMod";

	// Delete after 500 frames
	if (++count1 > 500 && ani_no == 5 && ani_wait == 2)
		Destroy();

	// Blink after 400 frames
	if (count1 > 400)
	{
		if (count1 / 2 % 2)
			ani.png = L"";
	}
}

void CS_Exp::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
}

void CS_Exp::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"unlimit_speed")
		limit_speed = false;
}

bool CS_Exp::Item(std::weak_ptr<Entity> src)
{
	//ֻҲʰȡ
	auto wsrc = src.lock();
	if (!wsrc)
		return false;
	if (wsrc->type == 1)
		return true;
	else
		return false;
}

void CS_Exp::SetSize(int sz)
{
	switch (sz)
	{
	default:
	case 0:
		cbRect.left = cbRect.top = cbRect.right = cbRect.bottom = 4;
		ani.sprite_index = L"ls_exp_small";
		dropExp = 1;
		break;
	case 1:
		cbRect.left = cbRect.top = cbRect.right = cbRect.bottom = 5;
		ani.sprite_index = L"ls_exp_medium";
		dropExp = 5;
		break;
	case 2:
		cbRect.left = cbRect.top = cbRect.right = cbRect.bottom = 7;
		ani.sprite_index = L"ls_exp_large";
		dropExp = 20;
		break;
	}
}

void CS_Exp::SetLeftFloat()
{
	lFloat = true;
}

void CS_Exp::SetRightFloat()
{
	rFloat = true;
}

std::shared_ptr<Entity> CreateCS_Exp()
{
	return std::make_shared<CS_Exp>();
}

void SetCS_Exp(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	int smallNum, mediumNum, largeNum;
	largeNum = num / 20;
	mediumNum = (num % 20) / 5;
	smallNum = (num % 20) % 5;
	for (int i = 0; i < smallNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(0);
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < mediumNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(1);
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < largeNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(2);
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetCS_ExpLFloat(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	int smallNum, mediumNum, largeNum;
	largeNum = num / 20;
	mediumNum = (num % 20) / 5;
	smallNum = (num % 20) % 5;
	for (int i = 0; i < smallNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(0);
		e->SetLeftFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < mediumNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(1);
		e->SetLeftFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < largeNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(2);
		e->SetLeftFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetCS_ExpRFloat(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	int smallNum, mediumNum, largeNum;
	largeNum = num / 20;
	mediumNum = (num % 20) / 5;
	smallNum = (num % 20) % 5;
	for (int i = 0; i < smallNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(0);
		e->SetRightFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < mediumNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(1);
		e->SetRightFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
	for (int i = 0; i < largeNum; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = y;
		e->SetSize(2);
		e->SetRightFloat();
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetDropItem(std::shared_ptr<Entity> parent, float x, float y, int dropExp)
{
	switch (Random(1, 5))
	{
	case 1:
		// Spawn health
		if (dropExp > 6)
			SetHeartLarge(parent, x, y);
		else
			SetHeartSmall(parent, x, y);
		break;
	default:
		SetCS_Exp(parent, x, y, dropExp);
		break;
	}
}

void SetDropItemLFloat(std::shared_ptr<Entity> parent, float x, float y, int dropExp)
{
	switch (Random(1, 5))
	{
	case 1:
		// Spawn health
		if (dropExp > 6)
			SetHeartLargeLFloat(parent, x, y);
		else
			SetHeartSmallLFloat(parent, x, y);
		break;
	default:
		SetCS_ExpLFloat(parent, x, y, dropExp);
		break;
	}
}

void SetDropItemRFloat(std::shared_ptr<Entity> parent, float x, float y, int dropExp)
{
	switch (Random(1, 5))
	{
	case 1:
		// Spawn health
		if (dropExp > 6)
			SetHeartLargeRFloat(parent, x, y);
		else
			SetHeartSmallRFloat(parent, x, y);
		break;
	default:
		SetCS_ExpRFloat(parent, x, y, dropExp);
		break;
	}
}
