#include "CS_Enemy_SunstoneWall.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_SunstoneWall::CS_Enemy_SunstoneWall()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_sunstonewall";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	hp_max = hp = 101;
	dropExp = 20;
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
}

void CS_Enemy_SunstoneWall::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	x += 0x1000 / ts;
	y += 0x1000 / ts;
	last_x = x;
	last_y = y;
	srcY = y;
	Entity::Init(self);
}

void CS_Enemy_SunstoneWall::Step()
{
	if (y != srcY)
		fix = false;
	if (!fix)
	{
		stateGravity.Step();
		if (!cbRect.cbBottom)
			bLanding = false;
		if (!bLanding)
		{
			if (cbRect.cbBottom)
			{
				gameFunc->PlaySound(L"CS_012_block_destroy");
				SetCS_PeSmokeSmall(shared_from_this(), x, y);
				bLanding = true;
			}
		}
	}
	if (!fix)
	{
		//һײ
		Entity::ClearCollisionResult();
	}
	//ִ˶
	Entity::Step();
	if (!fix)
	{
		//ִײ
		Entity::Collision();
	}
}

bool CS_Enemy_SunstoneWall::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (getDamage < 100)
		return true;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<Entity> CS_Enemy_SunstoneWall::BeginCaught(std::weak_ptr<Entity> e)
{
	return shared_from_this();
}

void CS_Enemy_SunstoneWall::EndCaught(std::weak_ptr<Entity> e)
{
}

std::shared_ptr<Entity> CreateCS_Enemy_SunstoneWall()
{
	return std::make_shared<CS_Enemy_SunstoneWall>();
}
