#include "CS_Enemy_Stumpy.h"
#include "CS_Exp.h"
#include "CS_PeSmoke.h"

CS_Enemy_Stumpy::CS_Enemy_Stumpy()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.waterBlock = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 4;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Stumpy::Step()
{
	int& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		act_no = 10;
		break;
	case 10:
		act_no = 11;
		act_wait = 0;
		vx = 0;
		vy = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x > wplayer->x)
					lr = 0;
				else
					lr = 1;
			}
		}
		[[fallthrough]];
	case 11:
		if (++act_wait > 50)
			act_no = 20;
		++ani_wait;
		if (act_wait > 1)
		{
			ani_wait = 0;

			if (++ani_no > 1)
				ani_no = 0;
		}
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				//
				if (wplayer->x > x + 0x28000 * 2 / ts || wplayer->x < x - 0x28000 * 2 / ts || wplayer->y > y + 0x1E000 * 2 / ts || wplayer->y < y - 0x1E000 * 2 / ts)
					act_no = 0;
			}
		}
		break;
	case 20:
		act_no = 21;
		act_wait = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				float dx = wplayer->x - x;
				float dy = wplayer->y - y;
				if (!(dx == 0 && dy == 0))
				{
					auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
					if (dy < 0)
						angle = 360 - angle;
					float dstDeg = 360.0f / 255.0f;
					float deg = angle + Random(-3, 3) * dstDeg;
					vy = 2 * sinf(deg * deg2rad);
					vx = 2 * cosf(deg * deg2rad);
				}
			}
		}
		if (vx < 0)
			lr = 0;
		else
			lr = 1;
		[[fallthrough]];
	case 21:
		if (cbRect.cbLeft)
		{
			lr = 1;
			vx = abs(vx);
		}
		if (cbRect.cbRight)
		{
			lr = 0;
			vx = -abs(vx);
		}
		if (cbRect.cbTop)
			vy = abs(vy);
		if (cbRect.cbBottom)
			vy = -abs(vy);
		if (cbRect.inWater)
			vy = -0x200 / ts;
		if (++act_wait > 50)
			act_no = 10;
		if (++ani_no > 1)
			ani_no = 0;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_stumpy_l" : L"ls_stumpy_r";
}

void CS_Enemy_Stumpy::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_stumpy_l" : L"ls_stumpy_r";
}

void CS_Enemy_Stumpy::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Stumpy::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Stumpy()
{
	return std::make_shared<CS_Enemy_Stumpy>();
}
