#include "CS_Enemy_Starfish.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeBubbleBeamHit.h"

CS_Enemy_Starfish::CS_Enemy_Starfish()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 2;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	speedDir = true;
	ignoreTrap = true;
}

void CS_Enemy_Starfish::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Starfish::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	if (!cbRect.inWater)
		stateGravity.Step();
	stateSplash.Step();
	//
	vx /= 1.01f;
	vy /= 1.01f;
	if (abs(vx) < 0.001f)
		vx = 0;
	if (abs(vy) < 0.001f)
		vy = 0;
	if (dash_interval_counter > 0)
	{
		dash_interval_counter--;
	}
	else
	{
		//ҿ̫Զ
		if (gameFunc->GetPlayerDistanceWithLineTest)
		{
			auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (abs(x - wplayer->x) <= 96 && abs(y - wplayer->y) <= 96)
					Dash(wplayer);
			}
		}
	}
	if (abs(vx) + abs(vy) <= 0.5f && dash_interval_counter == 0)
	{
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		ani.sprite_index = L"ls_starfish_wink";
	}
	else
	{
		ani.sprite_index = lr == 0 ? L"ls_starfish_rotate_l" : L"ls_starfish_rotate_r";
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	float lastVx = vx;
	float lastVy = vy;
	Entity::Collision();
	//ǽ
	if (cbRect.cbLeft)
	{
		lr = 0;
		vx = abs(lastVx);
	}
	else if (cbRect.cbRight)
	{
		lr = 1;
		vx = -abs(lastVx);
	}
	if (cbRect.cbTop)
	{
		vy = abs(lastVy);
	}
	else if (cbRect.cbBottom)
	{
		vy = -abs(lastVy);
	} 
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
}

void CS_Enemy_Starfish::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = L"ls_starfish_wink";
}

void CS_Enemy_Starfish::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Starfish::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt0");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_Starfish::Dash(std::shared_ptr<Entity> target)
{
	XMVECTOR vec = XMVector2Normalize(XMVectorSet(x - target->x, y - target->y, 0, 0));
	vx = dashSpeed * XMVectorGetX(vec);
	vy = dashSpeed * XMVectorGetY(vec);
	lr = vy > 0;
	dash_interval_counter = dash_interval_counter_max;
	gameFunc->PlaySound(L"CS_sea_enemy_shrimp");
	SetCS_PeBubbleBeamHit(shared_from_this(), x, y);
}

std::shared_ptr<Entity> CreateCS_Enemy_Starfish()
{
	return std::make_shared<CS_Enemy_Starfish>();
}
