#include "CS_Enemy_SoapB.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_SoapB::CS_Enemy_SoapB()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	hp_max = hp = 5;
	dropExp = 2;
	drawBeforeOtherEntity = true;
	el.name = CS_ENEMY_SOAPB_CREATENAME;
	stateGravity.SetGravityScale(0.75f);
}

void CS_Enemy_SoapB::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	auto watkZone = std::make_shared<CS_Enemy_SoapFrontDmgRect>(shared_from_this());
	atkZone = watkZone;
	watkZone->dmg = 2;
	gameFunc->SetEntity(shared_from_this(), watkZone);
	Entity::Init(self);
}

void CS_Enemy_SoapB::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	if (shock_counter == 0)
	{
		if (cbRect.cbLeft)
		{
			lr = 1;
			vx = 0x200 / ts;
		}

		if (cbRect.cbRight)
		{
			lr = 0;
			vx = -0x200 / ts;
		}
		//Ծ
		if (cbRect.cbBottom && Random(0, 120) == 10)
		{
			vy = -0x380 / ts;
		}
		//ͷ
		if (cbRect.cbBottom && Random(0, 120) == 10)
		{
			lr = lr == 0 ? 1 : 0;
		}
		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
		if (cbRect.cbBottom)
			ani.sprite_index = lr == 0 ? L"ls_soapB_move_l" : L"ls_soapB_move_r";
		else
			ani.sprite_index = lr == 0 ? L"ls_soapB_jump_l" : L"ls_soapB_jump_r";
	}
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		if (lr == 0)
		{
			watkZone->x = x - 5;
			watkZone->last_x = last_x - 5;
			watkZone->y = y;
			watkZone->last_y = last_y;
		}
		else
		{
			watkZone->x = x + 5;
			watkZone->last_x = last_x + 5;
			watkZone->y = y;
			watkZone->last_y = last_y;
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_SoapB::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_soapB_stand_l" : L"ls_soapB_stand_r";
	ani.image_index = 0;
}

bool CS_Enemy_SoapB::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}	
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	vx = lr == 0 ? -1.0f : 1.0f;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_SoapB::Destroy()
{
	auto watkZone = atkZone.lock();
	if (watkZone)
		watkZone->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_Enemy_SoapB()
{
	return std::make_shared<CS_Enemy_SoapB>();
}
