#include "CS_Enemy_Skullstep_Leg.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_Skullstep.h"
CS_Enemy_Skullstep_Leg::CS_Enemy_Skullstep_Leg(std::weak_ptr<CS_Enemy_Skullstep> parent)
{
	type = 2;
	this->parent = parent;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = 10;
	cbRect.top = 4;
	cbRect.bottom = 4;
	hp_max = hp = 10;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Skullstep_Leg::Step()
{
	int deg = 0;
	auto& ani_no = ani.image_index;
	auto wparent = parent.lock();
	if (!wparent)
	{
		Destroy();
		return;
	}
	if (wparent->inUsing == false)
	{
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		Destroy();
		return;
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		count1 = 10;
		[[fallthrough]];
	case 1:
		{
			if (cbRect.cbBottom)
			{
				wparent->y -= 0x400 / ts;
				wparent->vy -= 0x100 / ts;

				if (wparent->lr == 0)
					wparent->vx -= 0x80 / ts;
				else
					wparent->vx += 0x80 / ts;
			}
			{
				deg = (unsigned char)(phase)+(unsigned char)wparent->count2_last;
				float last_radian = (wparent->count2_last + phase) * 360.0f / 255.0f * deg2rad;
				last_x = wparent->last_x + count1 * cosf(last_radian);
				last_y = wparent->last_y + count1 * sinf(last_radian);
			}
			{
				deg = (unsigned char)(phase)+(unsigned char)wparent->count2;
				float radian = (wparent->count2 + phase) * 360.0f / 255.0f * deg2rad;
				x = wparent->x + count1 * cosf(radian);
				y = wparent->y + count1 * sinf(radian);
			}
			
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	lr = wparent->lr;
	if (deg >= 20 && deg <= 108)
		ani_no = 0;
	else
		ani_no = 1;
	ani.sprite_index = lr == 0 ? L"ls_skullstep_leg_l" : L"ls_skullstep_leg_r";
}

void CS_Enemy_Skullstep_Leg::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 8;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Skullstep_Leg::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<CS_Enemy_Skullstep_Leg> SetCS_Enemy_Skullstep_Leg(std::shared_ptr<CS_Enemy_Skullstep> parent)
{
	auto e = std::make_shared<CS_Enemy_Skullstep_Leg>(parent);
	parent->gameFunc->SetEntity(parent, e);
	return e;
}
