#include "CS_Enemy_Skullstep.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_Skullstep_Leg.h"
CS_Enemy_Skullstep::CS_Enemy_Skullstep()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 14;
	cbRect.top = 8;
	cbRect.bottom = 4;
	hp_max = hp = 20;
	dropExp = 10;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Skullstep::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Skullstep::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		{
			auto wleg1 = SetCS_Enemy_Skullstep_Leg(std::static_pointer_cast<CS_Enemy_Skullstep>(shared_from_this())).lock();
			if (wleg1)
				wleg1->drawBeforeOtherEntity = true;
			auto wleg2 = SetCS_Enemy_Skullstep_Leg(std::static_pointer_cast<CS_Enemy_Skullstep>(shared_from_this())).lock();
			if (wleg2)
				wleg2->phase = 128;
			act_no = 1;
			ani_no = 1;
		}
		[[fallthrough]];
	case 1:
		count2_last = count2;
		count2 += lr == 0 ? -6 : 6;
		if (cbRect.cbBottom)
		{
			vx = 3 * vx / 4;
			if (++act_wait > 60)
			{
				act_no = 2;
				act_wait = 0;
			}
		}
		else
		{
			act_wait = 0;
		}
		if (cbRect.cbLeft)
		{
			if (++count1 > 8)
			{
				lr = 1;
				vx = abs(vx);
			}
		}
		else if (cbRect.cbRight)
		{
			if (++count1 > 8)
			{
				lr = 0;
				vx = -abs(vx);
			}
		}
		else
		{
			count1 = 0;
		}
		break;
	case 2:
		++act_wait;
		shock_counter += (unsigned char)act_wait;
		if (act_wait > 50)
		{
			Destroy();
			SetCS_PeSmokeMedium(shared_from_this(), x, y);
			gameFunc->PlaySound(L"CS_025_funny_explode");
		}
		break;
	}
	vy += 0x80 / ts;
	if (vx > 0x2FF / ts)
		vx = 0x2FF / ts;
	if (vx < -0x2FF / ts)
		vx = -0x2FF / ts;

	if (vy > 0x2FF / ts)
		vy = 0x2FF / ts;
	if (vy < -0x2FF / ts)
		vy = -0x2FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_skullhead_l" : L"ls_skullhead_r";
}

void CS_Enemy_Skullstep::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_skullhead_l" : L"ls_skullhead_r";
}

void CS_Enemy_Skullstep::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 8;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Skullstep::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Skullstep()
{
	return std::make_shared<CS_Enemy_Skullstep>();
}
