#include "CS_Enemy_SeaSmile.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_SeaSmile::CS_Enemy_SeaSmile()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 10;
	cbRect.top = cbRect.bottom = 9;
	hp_max = hp = 7;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_SeaSmile::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_SeaSmile::Step()
{
	stateSplash.Step();
	if (flip_interval_counter == 0)
	{
		//Ϸ·ʱת
		if (cbRect.cbBottom || cbRect.cbTop)
		{
			if (gameFunc->GetGlobalEntityTable)
			{
				auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
				for (auto& p : allPlayer)
				{
					auto wplayer = p.second.lock();
					if (wplayer)
					{
						if (wplayer->el.name == L"null")
							continue;
						if (wplayer->hide)
							continue;
						if (((bInvert && wplayer->y > y) || (!bInvert && wplayer->y < y)) &&
							abs(wplayer->x - x) <= 10)
						{
							if (gameFunc->LineTest(shared_from_this(), x / 16, y / 16, wplayer->x / 16, wplayer->y / 16))
								continue;
							Flip();
							break;
						}
					}
				}
			}
		}
	}
	if (flip_interval_counter > 0)
		flip_interval_counter--;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	if (!cbRect.cbTop && !cbRect.cbBottom)
	{
		//ڿ
		if(bInvert)
			ani.sprite_index = lr == 0 ? L"ls_seaslime_jump_lu" : L"ls_seaslime_jump_ru";
		else
			ani.sprite_index = lr == 0 ? L"ls_seaslime_jump_ld" : L"ls_seaslime_jump_rd";
	}
	else
	{
		if (!bLanding)
		{
			gameFunc->PlaySound(L"CS_sea_enemy_oct_land");
			bLanding = true;
		}
		//ڵ
		if (bInvert)
			ani.sprite_index = lr == 0 ? L"ls_seaslime_stand_lu" : L"ls_seaslime_stand_ru";
		else
			ani.sprite_index = lr == 0 ? L"ls_seaslime_stand_ld" : L"ls_seaslime_stand_rd";
		//ڸ
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x - 112 < wplayer->x && x + 112 > wplayer->x && y - 80 < wplayer->y && y + 80 > wplayer->y)
					ani.image_index = 1;
				else
					ani.image_index = 0;
			}
		}
	}
}

void CS_Enemy_SeaSmile::SetState(int stateID, int lr)
{
	this->lr = lr;
	bInvert = el.arg == L"invert";
	if (bInvert)
		ani.sprite_index = lr == 0 ? L"ls_seaslime_stand_lu" : L"ls_seaslime_stand_ru";
	else
		ani.sprite_index = lr == 0 ? L"ls_seaslime_stand_ld" : L"ls_seaslime_stand_rd";
}

void CS_Enemy_SeaSmile::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_SeaSmile::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		//·ת
		if (cbRect.cbBottom || cbRect.cbTop)
			Flip();
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_SeaSmile::Flip()
{
	flip_interval_counter = flip_interval_counter_max;
	vy = bInvert ? jumpSpeed : -jumpSpeed;
	bInvert = !bInvert;
	bLanding = false;
	gameFunc->PlaySound(L"CS_sea_enemy_oct_jump");
}

std::shared_ptr<Entity> CreateCS_Enemy_SeaSmile()
{
	return std::make_shared<CS_Enemy_SeaSmile>();
}
