#include "CS_Enemy_SandBeetle.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_SandBeetle::CS_Enemy_SandBeetle()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 4;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
	ani.hideLayerList.insert(0);
}

void CS_Enemy_SandBeetle::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		if (lr == 0)
			act_no = 1;
		else
			act_no = 3;
		break;
	case 1:
		// Accelerate to the left
		vx_set -= 0x10 / ts;
		if (vx_set < -0x400 / ts)
			vx_set = -0x400 / ts;
		// Move
		if (shock_counter > 0)
			vx = vx_set / 2;
		else
			vx = vx_set;
		// Animate
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 1;
		// Stop when hitting a wall
		if (cbRect.cbLeft)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 0;
			vx_set = vx = 0;
			lr = 1;
		}
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x < wplayer->x && x > wplayer->x - 0x200 && y < wplayer->y + 8 && y > wplayer->y - 8)
				{
					act_no = 3;
					ani_wait = 0;
					ani_no = 1;
				}
			}
		}
		break;

	case 3:
		// Accelerate to the right
		vx_set += 0x10 / ts;
		if (vx_set > 0x400 / ts)
			vx_set = 0x400 / ts;
		// Move
		if (shock_counter > 0)
			vx = vx_set / 2;
		else
			vx = vx_set;
		// Animate
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 1;
		// Stop when hitting a wall
		if (cbRect.cbRight)
		{
			act_no = 4;
			act_wait = 0;
			ani_no = 0;
			vx_set = vx = 0;
			lr = 0;
		}
		break;
	case 4:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x < wplayer->x + 0x200 && x > wplayer->x && y < wplayer->y + 8 && y > wplayer->y - 8)
				{
					act_no = 1;
					ani_wait = 0;
					ani_no = 1;
				}
			}
		}
		break;
	}
	ani.sprite_index = lr == 0 ? L"ls_beetle_l" : L"ls_beetle_r";
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Enemy_SandBeetle::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_beetle_l" : L"ls_beetle_r";
}

void CS_Enemy_SandBeetle::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_SandBeetle::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_SandBeetle()
{
	return std::make_shared<CS_Enemy_SandBeetle>();
}
