#include "CS_Enemy_RedLeech.h"
#include "CS_Exp.h"
#include "CS_PeSmoke.h"

CS_Enemy_RedLeech::CS_Enemy_RedLeech()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	hp_max = hp = 4;
	dropExp = 4;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ignoreTrap = true;
	ani.hideLayerList.insert(0);
}

void CS_Enemy_RedLeech::Step()
{
	if (cbRect.cbLeft)
	{
		vx = moveSpeed;
		lr = 1;
	}
	if (cbRect.cbRight)
	{
		vx = -moveSpeed;
		lr = 0;
	}
	if (cbRect.cbTop)
		vy = moveSpeed;
	if (cbRect.cbBottom)
		vy = -moveSpeed;
	if (!cbRect.inWater)
		vy = moveSpeed;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (shock_counter > 0)
	{
		ani.sprite_index = lr == 0 ? L"ls_leech_hurt_l" : L"ls_leech_hurt_r";
	}
	else
	{
		if (vy < 0)
			ani.sprite_index = lr == 0 ? L"ls_leech_swim_lu" : L"ls_leech_swim_ru";
		else
			ani.sprite_index = lr == 0 ? L"ls_leech_swim_ld" : L"ls_leech_swim_rd";
	}
}

void CS_Enemy_RedLeech::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (lr == 0)
	{
		vx = -moveSpeed;
		vy = moveSpeed;
	}
	else
	{
		vx = moveSpeed;
		vy = moveSpeed;
	}
	if (vy < 0)
		ani.sprite_index = lr == 0 ? L"ls_leech_swim_lu" : L"ls_leech_swim_ru";
	else
		ani.sprite_index = lr == 0 ? L"ls_leech_swim_ld" : L"ls_leech_swim_rd";
}

void CS_Enemy_RedLeech::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_RedLeech::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_RedLeech()
{
	return std::make_shared<CS_Enemy_RedLeech>();
}
