#include "CS_Enemy_PolishBaby.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_PolishBaby::CS_Enemy_PolishBaby()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_polishbaby";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	hp_max = hp = 2;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 5;
	el.name = CS_ENEMY_POLISHBABY_CREATENAME;
}

void CS_Enemy_PolishBaby::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		if (Random(0, 1))
			vx_set = Random(-0x200, -0x100) / ts;
		else
			vx_set = Random(0x100, 0x200) / ts;
		if (Random(0, 1))
			vy_set = Random(-0x200, -0x100) / ts;
		else
			vy_set = Random(0x100, 0x200) / ts;
		[[fallthrough]];
	case 1:
		[[fallthrough]];
	case 2:
		if (++ani_no > 1)
			ani_no = 0;
		break;
	}
	if (cbRect.cbLeft)
		vx_set = abs(vx_set);
	if (cbRect.cbRight)
		vx_set = -abs(vx_set);
	if (cbRect.cbTop)
		vy_set = abs(vy_set);
	if (cbRect.cbBottom)
		vy_set = -abs(vy_set);

	if (vx_set > 0x200 / ts)
		vx_set = 0x200 / ts;
	if (vx_set < -0x200 / ts)
		vx_set = -0x200 / ts;

	if (vy_set > 0x200 / ts)
		vy_set = 0x200 / ts;
	if (vy_set < -0x200 / ts)
		vy_set = -0x200 / ts;

	if (shock_counter > 0)
	{
		vx = vx_set / 2;
		vy = vy_set / 2;
	}
	else
	{
		vx = vx_set;
		vy = vy_set;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Enemy_PolishBaby::SetState(int stateID, int lr)
{
	this->lr = lr;
}

void CS_Enemy_PolishBaby::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_PolishBaby::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_PolishBaby()
{
	return std::make_shared<CS_Enemy_PolishBaby>();
}
