#include "CS_Enemy_Pignon.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_Pignon::CS_Enemy_Pignon()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	hp_max = hp = 2;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Pignon::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Pignon::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	if (shock_counter == 0)
	{
		if (cbRect.cbLeft)
		{
			lr = 1;
			vx = 0x200 / ts;
		}

		if (cbRect.cbRight)
		{
			lr = 0;
			vx = -0x200 / ts;
		}

		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
		ani.sprite_index = lr == 0 ? L"ls_pignon_move_l" : L"ls_pignon_move_r";
	}
	else
	{
		ani.sprite_index = lr == 0 ? L"ls_pignon_hurt_l" : L"ls_pignon_hurt_r";
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_Pignon::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_pignon_stand_l" : L"ls_pignon_stand_r";
	ani.image_index = 0;
}

void CS_Enemy_Pignon::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Pignon::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	vx = lr == 0 ? -1.0f : 1.0f;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Pignon()
{
	return std::make_shared<CS_Enemy_Pignon>();
}
