#include "CS_Enemy_Octopus.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_OctopusBlade.h"
CS_Enemy_Octopus::CS_Enemy_Octopus()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 10;
	cbRect.top = cbRect.bottom = 9;
	hp_max = hp = 7;
	dropExp = 2;
	coyote_max = 0;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Octopus::Step()
{
	if (shot_interval_counter > 0)
	{
		shot_interval_counter--;
	}
	else
	{
		//
		if (gameFunc->GetPlayerDistanceLRWithLineTest)
		{
			auto wplayer = gameFunc->GetPlayerDistanceLRWithLineTest(gameFunc->game, x, y, lr).lock();
			if (wplayer)
			{
				if (x - 128 * 2 < wplayer->x && x + 128 * 2 > wplayer->x &&
					y - 96 * 2 < wplayer->y && y + 96 * 2 > wplayer->y)
				{
					//
					gameFunc->PlaySound(L"CS_sea_enemy_shot1");
					XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - y, 0, 0));
					SetCS_Enemy_OctopusBlade(shared_from_this(),
						x + (lr == 0 ? -8.0f : 8.0f),
						y,
						shotSpeed * XMVectorGetX(vec),
						shotSpeed * XMVectorGetY(vec));
					shot_counter = 30;
					shot_interval_counter = 300;
				}
			}
		}
	}
	if (shot_counter > 0)
	{
		vx = 0;
		if (bInvert)
			ani.sprite_index = lr == 0 ? L"ls_octopus_shot_lu" : L"ls_octopus_shot_ru";
		else
			ani.sprite_index = lr == 0 ? L"ls_octopus_shot_ld" : L"ls_octopus_shot_rd";
		shot_counter--;
	}
	else
	{
		if (cbRect.cbLeft)
		{
			lr = 1;
			vx = 0x100 / ts;
		}
		if (cbRect.cbRight)
		{
			lr = 0;
			vx = -0x100 / ts;
		}
		if (lr == 0)
			vx = -0x80 / ts;
		else
			vx = 0x80 / ts;
		if (bInvert)
			ani.sprite_index = lr == 0 ? L"ls_octopus_move_lu" : L"ls_octopus_move_ru";
		else
			ani.sprite_index = lr == 0 ? L"ls_octopus_move_ld" : L"ls_octopus_move_rd";
	}
	//ִ˶
	Entity::Step();
	//ͷ
	TurnBack();
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
}

void CS_Enemy_Octopus::SetState(int stateID, int lr)
{
	this->lr = lr;
	bInvert = el.arg == L"invert";
	if (bInvert)
		ani.sprite_index = lr == 0 ? L"ls_octopus_move_lu" : L"ls_octopus_move_ru";
	else
		ani.sprite_index = lr == 0 ? L"ls_octopus_move_ld" : L"ls_octopus_move_rd";
}

void CS_Enemy_Octopus::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Octopus::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt1");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_Octopus::TurnBack()
{
	bool& pCbSide = bInvert ? cbRect.cbTop : cbRect.cbBottom;
	if (!pCbSide)
		return;
	float dy = bInvert ? -4.0f : 4.0f;
	//ǰǿյͷ
	float srcX = x;
	float srcY = y;
	ignoreTrap = true;
	cbRect.enableSoild = false;
	if (lr == 0)
	{
		x -= 4;
		y += dy;
		Entity::ClearCollisionResult();
		Entity::Collision();
		//·ǿյͷ
		if (!pCbSide || cbRect.onTrap)
		{
			lr = 1;
			vx = 0x200 / ts;
		}
	}
	else
	{
		x += 4;
		y += dy;
		Entity::ClearCollisionResult();
		Entity::Collision();
		//·ǿյͷ
		if (!pCbSide || cbRect.onTrap)
		{
			lr = 0;
			vx = -0x200 / ts;
		}
	}
	//ԭ
	x = srcX;
	y = srcY;
	ignoreTrap = false;
	cbRect.enableSoild = true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Octopus()
{
	return std::make_shared<CS_Enemy_Octopus>();
}
