#include "CS_Enemy_Mannan.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_MannanBlade.h"
CS_Enemy_Mannan::CS_Enemy_Mannan()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = 4;
	cbRect.top = 16;
	cbRect.bottom = 8;
	hp_max = hp = 10;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Mannan::Step()
{
	auto& ani_no = ani.image_index;
	if (act_no < 3 && hp <= 0)
	{
		act_no = 3;
		act_wait = 0;
		ani_no = 2;
	}
	switch (act_no)
	{
	case 0:
	case 1:
		break;
	case 2:
		if (++act_wait > 20)
		{
			act_wait = 0;
			act_no = 1;
			ani_no = 0;
		}
		break;
	case 3:
		if (++act_wait == 50 || act_wait == 60)
			ani_no = 3;
		if (act_wait == 53 || act_wait == 63)
			ani_no = 2;
		if (act_wait > 100)
			act_no = 4;
		break;
	}
	ani.sprite_index = lr == 0 ? L"ls_mannan_l" : L"ls_mannan_r";
}

void CS_Enemy_Mannan::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_mannan_l" : L"ls_mannan_r";
}

void CS_Enemy_Mannan::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp > 0)
	{
		*outDamage = 3;
		auto wdst = dst.lock();
		if (wdst)
		{
			if (wdst->lr == 0)
			{
				*outAngle = 315;
			}
			else
			{
				*outAngle = 225;
			}
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}	
}

bool CS_Enemy_Mannan::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (hp <= 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
		SetCS_Enemy_MannanBlade(shared_from_this());
		auto& ani_no = ani.image_index;
		ani_no = 1;
		act_no = 2;
		act_wait = 0;
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Mannan()
{
	return std::make_shared<CS_Enemy_Mannan>();
}
