#include "CS_Enemy_LavaBat.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmLava.h"
CS_Enemy_LavaBat::CS_Enemy_LavaBat()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 7;
	cbRect.bottom = 4;
	cbRect.waterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(3);
	hp_max = hp = 1;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_LavaBat::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_Enemy_LavaBat::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		count1 = 120;
		act_no = 1;
		act_wait = Random(0, 50);
		[[fallthrough]];
	case 1:
		if (++act_wait < 50)
			break;
		act_wait = 0;
		act_no = 2;
		vy = 0x300 / ts;
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = wplayer->x < x ? 0 : 1;
			}
		}
		if (srcY < y)
			vy -= 0x10 / ts;
		if (srcY > y)
			vy += 0x10 / ts;
		if (vy > 0x300 / ts)
			vy = 0x300 / ts;
		if (vy < -0x300 / ts)
			vy = -0x300 / ts;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (++ani_wait > 1)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 2)
		ani_no = 0;
	ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
}

void CS_Enemy_LavaBat::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
}

void CS_Enemy_LavaBat::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_LavaBat::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
		//
		SetCS_AmLava(shared_from_this(), x, y, Random(-0x300, 0x300) / ts, Random(-0x500, -0x200) / ts);
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_LavaBat()
{
	return std::make_shared<CS_Enemy_LavaBat>();
}
