#include "CS_Enemy_Jelly.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Jelly::CS_Enemy_Jelly()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 4;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Jelly::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_Enemy_Jelly::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		act_wait = Random(0, 20);
		if (lr == 0)
			vx = 0x200 / ts;
		else
			vx = -0x200 / ts;
		[[fallthrough]];
	case 1:
		if (--act_wait > 0)
			break;
		act_no = 10;
		[[fallthrough]];
	case 10:
		if (++act_wait > 10)
		{
			act_wait = 0;
			ani_wait = 0;
			act_no = 11;
		}
		break;
	case 11:
		if (++ani_wait > 5)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no == 2)
		{
			if (lr == 0)
				vx -= 0x100 / ts;
			else
				vx += 0x100 / ts;

			vy -= 0x200 / ts;
		}
		if (ani_no > 2)
		{
			act_no = 12;
			ani_no = 3;
		}
		break;
	case 12:
		++act_wait;
		if (y > srcY && act_wait > 10)
		{
			act_wait = 0;
			act_no = 10;
			ani_no = 0;
		}
		break;
	}
	if (x > srcX)
		lr = 0;
	else
		lr = 1;
	if (cbRect.cbLeft)
	{
		count1 = 50;
		lr = 1;
	}
	if (cbRect.cbRight)
	{
		count1 = 50;
		lr = 0;
	}
	if (count1 > 0)
		count1--;
	vy += 0x20 / ts;
	if (cbRect.cbBottom)
		vy = -0x400 / ts;
	if (vx > 0x100 / ts)
		vx = 0x100 / ts;
	if (vx < -0x100 / ts)
		vx = -0x100 / ts;
	if (vy > 0x200 / ts)
		vy = 0x200 / ts;
	if (vy < -0x200 / ts)
		vy = -0x200 / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_jelly_l" : L"ls_jelly_r";
}

void CS_Enemy_Jelly::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_jelly_l" : L"ls_jelly_r";
}

void CS_Enemy_Jelly::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Jelly::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Jelly()
{
	return std::make_shared<CS_Enemy_Jelly>();
}
