#include "CS_Enemy_GolemScissorsClone.h"
#include "PeSmog.h"

CS_Enemy_GolemScissorsClone::CS_Enemy_GolemScissorsClone(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_golem_scissors_d";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = cbRect.bottom = 16;
	drawBeforeOtherEntity = true;
	speedDir = true;
}

void CS_Enemy_GolemScissorsClone::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GolemScissorsClone::Step()
{
	stateGravity.Step();
	stateSplash.Step();
	//ǽ
	if (cbRect.cbLeft)
		vx = abs(vx);
	if (cbRect.cbRight)
		vx = -abs(vx);
	//ʧ
	if (cbRect.cbBottom)
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, (float)Random(0, 360));
		SetPeSmog(shared_from_this(), x, y, 1, 1, (float)Random(0, 360));
		Destroy();
	}
	srcVx = vx;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	vx = srcVx;
	//άб
	Entity::KeepOnSlopes();
	//
	ani.sprite_index = vy < 0 ? L"ls_golem_scissors_u" : L"ls_golem_scissors_d";
}

void CS_Enemy_GolemScissorsClone::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void SetCS_Enemy_GolemScissorsClone(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_Enemy_GolemScissorsClone>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
