#include "CS_Enemy_Gaudi.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Gaudi::CS_Enemy_Gaudi()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 11;
	cbRect.bottom = 8;
	hp_max = hp = 15;
	dropExp = 8;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Gaudi::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Gaudi::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	if (hp > 0)
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			vx = 0;
			ani_no = 0;
			[[fallthrough]];
		case 1:
			if (Random(0, 100) == 1)
			{
				act_no = 2;
				ani_no = 1;
				act_wait = 0;
			}
			if (Random(0, 100) == 1)
				lr = lr == 0 ? 1 : 0;
			if (Random(0, 100) == 1)
				act_no = 10;
			break;
		case 2:
			if (++act_wait > 20)
			{
				act_no = 1;
				ani_no = 0;
			}
			break;
		case 10:
			act_no = 11;
			act_wait = Random(25, 100);
			ani_no = 2;
			ani_wait = 0;
			[[fallthrough]];
		case 11:
			if (++ani_wait > 3)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 5)
				ani_no = 2;
			vx = lr == 0 ? -0x200 / ts : 0x200 / ts;
			if (act_wait)
			{
				--act_wait;
			}
			else
			{
				act_no = 1;
				ani_no = 0;
				vx = 0;
			}
			if (cbRect.cbLeft)
			{
				ani_no = 2;
				vy = -0x5FF / ts;
				act_no = 20;
				gameFunc->PlaySound(L"CS_030_critter_jump");
			}
			else if (cbRect.cbRight)
			{
				ani_no = 2;
				vy = -0x5FF / ts;
				act_no = 20;
				gameFunc->PlaySound(L"CS_030_critter_jump");
			}
			break;
		case 20:
			if (cbRect.cbLeft)
				++count1;
			else if (cbRect.cbRight)
				++count1;
			else
				count1 = 0;
			if (count1 > 10)
				lr = lr == 0 ? 1 : 0;
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
			if (cbRect.cbBottom)
			{
				act_no = 21;
				ani_no = 20;
				act_wait = 0;
				vx = 0;
				gameFunc->PlaySound(L"CS_023_thud");
			}
			break;
		case 21:
			if (++act_wait > 10)
			{
				act_no = 1;
				ani_no = 0;
			}
			break;
		}
		vy += 0x40 / ts;
	}
	else
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			ani_no = 9;
			vy = -0x200 / ts;
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
			gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
			break;
		case 1:
			if (cbRect.cbBottom)
			{
				ani_no = 10;
				ani_wait = 0;
				act_no = 2;
				act_wait = 0;
			}
			break;
		case 2:
			vx = 8 * vx / 9;
			if (++ani_wait > 3)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 11)
				ani_no = 10;
			if (++act_wait > 50)
			{
				gameFunc->PlaySound(L"CS_071_little_crash");
				//
				SetCS_PeSmokeMedium(shared_from_this(), x, y);

				//Ʒ
				SetDropItem(shared_from_this(), x, y, dropExp);
				Destroy();
			}
			break;
		}
		vy += 0x20 / ts;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
}

void CS_Enemy_Gaudi::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
}

void CS_Enemy_Gaudi::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp <= 0)
		return;
	*outDamage = 8;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Gaudi::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (hp <= 0)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	if (hp <= 0)
	{
		act_no = 0;
		hp = 0;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Gaudi()
{
	return std::make_shared<CS_Enemy_Gaudi>();
}
