#include "CS_Enemy_FireSpriteBlue.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_FireSpriteSmall.h"
CS_Enemy_FireSpriteBlue::CS_Enemy_FireSpriteBlue()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 7;
	cbRect.top = 8;
	cbRect.bottom = 8;
	hp_max = hp = 11;
	dropExp = 5;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ani.image_index = Random(0, 2);
	moveSpeed = 0x200 / ts;
}

void CS_Enemy_FireSpriteBlue::Init(std::weak_ptr<Entity> self)
{
	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	gameFunc->SetEntity(shared_from_this(), wpeLight);

	auto wpeLightColor = std::make_shared<CS_PeLightFade>();
	peLightColor = wpeLightColor;
	wpeLightColor->light.usingLight = false;
	wpeLightColor->color = RGBA(0, 0x98, 0xff, 0x10);
	gameFunc->SetEntity(shared_from_this(), wpeLightColor);

	wpeLight->SetRadius(5);
	wpeLightColor->SetRadius(5);
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	wpeLightColor->last_x = wpeLightColor->x = x;
	wpeLightColor->last_y = wpeLightColor->y = y;
	srcY = y;
	Entity::Init(self);
}

void CS_Enemy_FireSpriteBlue::Step()
{
	//ҷ
	if (cbRect.cbLeft)
	{
		vx = 1;
		lr = 1;
	}
	else if (cbRect.cbRight)
	{
		vx = -1;
		lr = 0;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//ˮ
	if (cbRect.inWater)
	{
		int out;
		Hurt(std::weak_ptr<Entity>(), 127, 0, false, 0, 0, 0, &out);
	}
	auto wpeLight = peLight.lock();
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
	auto wpeLightColor = peLightColor.lock();
	if (wpeLightColor)
	{
		wpeLightColor->x = x;
		wpeLightColor->last_x = last_x;
		wpeLightColor->y = y;
		wpeLightColor->last_y = last_y;
	}
	if (vx == 0 && vy == 0)
	{
		vx = lr == 0 ? -moveSpeed : moveSpeed;
	}
	if (y > srcY)
	{
		vy = -0x200 / ts;
	}
	else
	{
		vy = 0;
	}
	ani.sprite_index = lr == 0 ? L"ls_firesprite_blue_l" : L"ls_firesprite_blue_r";
}

void CS_Enemy_FireSpriteBlue::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_firesprite_blue_l" : L"ls_firesprite_blue_r";
	vx = lr == 0 ? -moveSpeed : moveSpeed;
}

void CS_Enemy_FireSpriteBlue::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_FireSpriteBlue::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_104");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		//
		static const int dirArr[] = { 7,9,1,3 };
		for (auto& i : dirArr)
		{
			auto we = std::make_shared<CS_Enemy_FireSpriteSmall>();
			we->SetDir(i);
			we->x = x;
			we->y = y;
			we->SetBlue();
			gameFunc->SetEntity(shared_from_this(), we);
		}
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_FireSpriteBlue::Destroy()
{
	auto wpeLight = peLight.lock();
	if (wpeLight)
		wpeLight->Destroy();
	auto wpeLightColor = peLightColor.lock();
	if (wpeLightColor)
		wpeLightColor->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_Enemy_FireSpriteBlue()
{
	return std::make_shared<CS_Enemy_FireSpriteBlue>();
}
