#include "CS_Enemy_Crow.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Crow::CS_Enemy_Crow()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	hp_max = hp = 20;
	dropExp = 9;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Crow::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Crow::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		{
			float deg = (float)Random(0, 360);
			vx = cosf(deg * deg2rad);
			deg += 90;
			tgt_x = x + 8 * cosf(deg * deg2rad);

			deg = (float)Random(0, 360);
			vy = sinf(deg * deg2rad);
			deg += 90;
			tgt_y = y + 8 * sin(deg * deg2rad);

			act_no = 1;
			count1 = 120;
			ani_no = Random(0, 1);
			ani_wait = Random(0, 4);
		}
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
					lr = 0;
				else
					lr = 1;
			}
		}
		if (tgt_x < x)
			vx -= 0x10 / ts;
		if (tgt_x > x)
			vx += 0x10 / ts;
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
		if (vx > 0x200 / ts)
			vx = 0x200 / ts;
		if (vx < -0x200 / ts)
			vx = -0x200 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		if (shock_counter > 0)
		{
			act_no = 2;
			act_wait = 0;
			if (lr == 0)
				vx = 0x200 / ts;
			else
				vx = -0x200 / ts;
			vy = 0;
		}
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
					lr = 0;
				else
					lr = 1;
				if (y > wplayer->y + 0x6000 / ts)
				{
					if (wplayer->x < x)
						vx += 0x10 / ts;
					if (wplayer->x > x)
						vx -= 0x10 / ts;
				}
				else
				{
					if (wplayer->x < x)
						vx -= 0x10 / ts;
					if (wplayer->x > x)
						vx += 0x10 / ts;
				}

				if (wplayer->y < y)
					vy -= 0x10 / ts;
				if (wplayer->y > y)
					vy += 0x10 / ts;
			}
		}
		if (shock_counter > 0)
		{
			vy += 0x20 / ts;
			vx = 0;
		}
		if (cbRect.cbLeft)
			vx = 0x200 / ts;
		if (cbRect.cbRight)
			vx = -0x200 / ts;
		if (cbRect.cbTop)
			vy = 0x200 / ts;
		if (cbRect.cbBottom)
			vy = -0x200 / ts;
		if (vx > 0x5FF / ts)
			vx = 0x5FF / ts;
		if (vx < -0x5FF / ts)
			vx = -0x5FF / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (shock_counter > 0)
	{
		ani_no = 2;
	}
	else
	{
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
	}
	ani.sprite_index = lr == 0 ? L"ls_crow_l" : L"ls_crow_r";
}

void CS_Enemy_Crow::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_crow_l" : L"ls_crow_r";
}

void CS_Enemy_Crow::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Crow::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Crow()
{
	return std::make_shared<CS_Enemy_Crow>();
}
