#include "CS_Enemy_Crab.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Crab::CS_Enemy_Crab()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 6;
	cbRect.bottom = 8;
	hp_max = hp = 12;
	dropExp = 5;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Crab::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Crab::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	if (cbRect.cbBottom)
	{
		if (jump_interval_counter > 0)
			jump_interval_counter--;
		//泯
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x > wplayer->x)
					lr = 0;
				else
					lr = 1;
				//ҽӽ
				if (jump_interval_counter == 0)
				{
					if (x - 80 < wplayer->x && x + 80 > wplayer->x && y - 80 < wplayer->y && y + 48 > wplayer->y)
						Jump();
				}
			}
		}
		if (!bLanding)
		{
			gameFunc->PlaySound(L"CS_sea_enemy_oct_land");
			bLanding = true;
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	if (cbRect.cbBottom)
		ani.sprite_index = lr == 0 ? L"ls_crab_stand_l" : L"ls_crab_stand_r";
	else
		ani.sprite_index = lr == 0 ? L"ls_crab_jump_l" : L"ls_crab_jump_r";
}

void CS_Enemy_Crab::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_crab_stand_l" : L"ls_crab_stand_r";
}

void CS_Enemy_Crab::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Crab::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt1");
		if (cbRect.cbBottom)
			Jump();
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_Crab::Jump()
{
	jump_interval_counter = jump_interval_counter_max;
	bLanding = false;
	vy = -0x800 / ts;
	if (lr == 0)
		vx = -0x200 / ts;
	else
		vx = 0x200 / ts;
	gameFunc->PlaySound(L"CS_sea_enemy_oct_jump");
}

std::shared_ptr<Entity> CreateCS_Enemy_Crab()
{
	return std::make_shared<CS_Enemy_Crab>();
}
