#include "CS_Enemy_BlackBat_Hover.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_BlackBat_Hover::CS_Enemy_BlackBat_Hover()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 7;
	cbRect.bottom = 4;
	cbRect.waterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	hp_max = hp = 4;
	dropExp = 3;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_BlackBat_Hover::Step()
{
	float deg;
	switch (act_no)
	{
	case 0:
		deg = (float)Random(0, 360);
		vx = cosf(deg * deg2rad);
		deg += 90;
		tgt_x = x + 8 * cosf(deg * deg2rad);

		deg = (float)Random(0, 360);
		vy = sinf(deg);
		deg += 90;
		tgt_y = y + 8 * sinf(deg * deg2rad);

		act_no = 1;
		count1 = 120;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
					lr = 0;
				else
					lr = 1;
			}
		}
		if (tgt_x < x)
			vx -= 0x10 / ts;
		if (tgt_x > x)
			vx += 0x10 / ts;

		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;

		if (vx > 0x200 / ts)
			vx = 0x200 / ts;
		if (vx < -0x200 / ts)
			vx = -0x200 / ts;

		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;

		if (count1 < 120)
		{
			++count1;
		}
		else
		{
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					if (x - 0x1000 / ts < wplayer->x && x + 0x1000 / ts > wplayer->x && y < wplayer->y && y + 0xC000 / ts > wplayer->y)
					{
						vx /= 2;
						vy = 0;
						act_no = 3;
						cbRect.enableSoild = true;
					}
				}
			}
		}
		break;
	case 3:
		vy += 0x40 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (cbRect.cbBottom)
		{
			vy = 0;
			vx *= 2;
			count1 = 0;
			act_no = 1;
			cbRect.enableSoild = false;
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (act_no == 3)
	{
		ani_no = 3;
	}
	else
	{
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}

		if (ani_no > 2)
			ani_no = 0;
	}
	if (ani_no < 3)
	{
		ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
		ani.image_index = ani_no;
	}
	else
	{
		ani.sprite_index = lr == 0 ? L"ls_bat_bite_l" : L"ls_bat_bite_r";
		ani.image_index = 0;
	}
}

void CS_Enemy_BlackBat_Hover::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
}

void CS_Enemy_BlackBat_Hover::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_BlackBat_Hover::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_BlackBat_Hover()
{
	return std::make_shared<CS_Enemy_BlackBat_Hover>();
}
