#include "CS_Enemy_Behemoth.h"
#include "CS_Exp.h"
#include "CS_PeSmoke.h"

CS_Enemy_Behemoth::CS_Enemy_Behemoth()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.top = 14;
	cbRect.left = cbRect.right = 11;
	cbRect.bottom = 8;
	hp_max = hp = 20;
	dropExp = 9;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Behemoth::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	auto watkZone = std::make_shared<CS_Enemy_BehemothFrontDmgRect>(shared_from_this());
	atkZone = watkZone;
	gameFunc->SetEntity(shared_from_this(), watkZone);
	Entity::Init(self);
}

void CS_Enemy_Behemoth::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	if (cbRect.cbLeft)
		lr = 1;
	else if (cbRect.cbRight)
		lr = 0;
	switch (act_no)
	{
	case 0: // Walking
		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
		if (++ani_wait > 8)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
			ani_no = 0;
		if (shock_counter > 0)
		{
			count1 = 0;
			act_no = 1;
			ani_no = 4;
		}
		break;
	case 1: // Shot
		vx = 7 * vx / 8;
		if (++count1 > 20)
		{
			if (shock_counter > 0)
			{
				count1 = 0;
				act_no = 2;
				ani_no = 6;
				ani_wait = 0;
				damage = 5;
			}
			else
			{
				act_no = 0;
				ani_wait = 0;
			}
		}
		break;
	case 2: // Charge
		if (lr == 0)
			vx = -0x400 / ts;
		else
			vx = 0x400 / ts;
		if (++count1 > 200)
		{
			act_no = 0;
			damage = 1;
		}
		if (++ani_wait > 5)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 6)
		{
			ani_no = 5;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 8, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x;
			pe->y = y + 0x600 / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		break;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		if (lr == 0)
		{
			watkZone->x = x - 12;
			watkZone->last_x = last_x - 12;
			watkZone->y = y + 3;
			watkZone->last_y = last_y + 3;
		}
		else
		{
			watkZone->x = x + 12;
			watkZone->last_x = last_x + 12;
			watkZone->y = y + 3;
			watkZone->last_y = last_y + 3;
		}
	}
	//ҶԾ
	Entity::GridTouch();
	for (auto& e : touchList)
	{
		auto we = e.lock();
		if (we)
		{
			if (we->type != 1)
				continue;
			if (we->cbRect.cbBottom)
				we->vy = -0x200 / ts;
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_behemoth_l" : L"ls_behemoth_r";
}

void CS_Enemy_Behemoth::SetState(int stateID, int lr)
{
	ani.sprite_index = lr == 0 ? L"ls_behemoth_l" : L"ls_behemoth_r";
}

bool CS_Enemy_Behemoth::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	vx = lr == 0 ? -1.0f : 1.0f;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_Behemoth::Destroy()
{
	auto watkZone = atkZone.lock();
	if (watkZone)
		watkZone->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_Enemy_Behemoth()
{
	return std::make_shared<CS_Enemy_Behemoth>();
}
