#include "CS_DiscoSpotlight.h"

CS_DiscoSpotlight::CS_DiscoSpotlight()
{
	ani.png = L"CS_CaveStoryMod";
}

void CS_DiscoSpotlight::Init(std::weak_ptr<Entity> self)
{
	auto wlight = std::make_shared<Entity>(3);
	light = wlight;
	wlight->x = x;
	wlight->y = y;
	wlight->light.usingLight = true;
	wlight->ani.png = L"light";
	wlight->ani.sprite_index = lr == 0 ? L"spotlight_l" : L"spotlight_r";
	gameFunc->SetEntity(shared_from_this(), wlight);
	Entity::Init(self);
}

void CS_DiscoSpotlight::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_disco_spotlight_l" : L"ls_disco_spotlight_r";
}

void CS_DiscoSpotlight::Destroy()
{
	auto wlight = light.lock();
	if (wlight)
		wlight->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_DiscoSpotlight()
{
	return std::make_shared<CS_DiscoSpotlight>();
}
