#include "CS_CurlyNemesisBlade.h"
#include "CS_Curly.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
#include "CS_PeSmoke.h"
CS_CurlyNemesisBlade::CS_CurlyNemesisBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 2;
	cbRect.bottom = 2;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 8;
		vx = 0;
		vy = -move;
		SetCS_PeGunShotSpark(parent, x, y);
		ani.sprite_index = L"am_nemesis_set_u";
	}
	else if (ud == 0)
	{
		y = parent->y + 3;
		if (lr == 0)
		{
			x = parent->x - 6;
			SetCS_PeGunShotSpark(parent, parent->x - 0x1800 / ts, y);
			ani.sprite_index = L"am_nemesis_set_l";
		}
		else
		{
			x = parent->x + 6;
			SetCS_PeGunShotSpark(parent, parent->x + 0x1800 / ts, y);
			ani.sprite_index = L"am_nemesis_set_r";
		}
		vx = lr == 0 ? -move : move;
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		vx = 0;
		vy = move;
		SetCS_PeGunShotSpark(parent, x, y);
		ani.sprite_index = L"am_nemesis_set_d";
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_117");
	//ʱ
	action_timecounter_max = 20;
	action_timecounter = action_timecounter_max;
	//
	damaged_limit = 4;
	damage_reset_counter = 0;
	//ǽײ
	SetCbRect_Collision();
}

void CS_CurlyNemesisBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ǽײ
	SetCbRect_Collision();
	//ִ˶
	Entity::Step();//
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	if (ani.image_index == 4)
	{
		if (ud == 0)
			ani.sprite_index = lr == 0 ? L"am_nemesis_l" : L"am_nemesis_r";
		else 
			ani.sprite_index = ud == -1 ? L"am_nemesis_u" : L"am_nemesis_d";
		ani.image_index = 0;
	}
	//ٶ
	if (ud == -1)
		vy = -move;
	else if (ud == 0)
		vx = lr == 0 ? -move : move;
	else
		vy = move;
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
	//Ч
	if (action_timecounter % 4 == 1)
	{
		//
		float dx = 0;
		float dy = 0;
		if (ud == 0)
		{
			dx = lr == 0 ? -0x200 / ts : 0x200 / ts;
			dy = Random(-0x200, 0x200) / ts;
		}
		else
		{
			dx = Random(-0x200, 0x200) / ts;
			dy = ud == -1 ? -0x200 / ts : 0x200 / ts;
		}
		float offset_x = (float)Random((int)-cbRect.left, (int)cbRect.right);
		float offset_y = (float)Random((int)-cbRect.top, (int)cbRect.bottom);
		auto e = std::make_shared<CS_PeSmoke>();
		e->x = x + offset_x;
		e->y = y + offset_y;
		e->vx = dx;
		e->vy = dy;
		gameFunc->SetEntity(shared_from_this(), e);
	}
}

void CS_CurlyNemesisBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_CurlyNemesisBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_CurlyNemesisBlade::Feedback(std::weak_ptr<Entity> target)
{
	if (damaged_counter == damaged_limit)
		Destroy();
}

void CS_CurlyNemesisBlade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto mychar = std::static_pointer_cast<CS_Curly>(wattackParent);
		auto& amList = mychar->skillNemesis.amList;
		for (auto iter = amList.begin(); iter != amList.end(); iter++)
		{
			if ((*iter).lock() == shared_from_this())
			{
				amList.erase(iter);
				break;
			}
		}
	}
	ActionEntity::Destroy();
}

void CS_CurlyNemesisBlade::SetCbRect_Entity()
{
	cbRect.left = 4;
	cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 4;
	cbRect.breakStarBlock = false;
}

void CS_CurlyNemesisBlade::SetCbRect_Collision()
{
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 3;
	cbRect.bottom = 3;
	cbRect.breakStarBlock = true;
}
