#include "CS_CurlyMachineGun.h"
#include "CS_Curly.h"
#include "CS_PeOutOfAmmo.h"
#include "CS_CurlyMachineGunBlade.h"
const int CS_CurlySTATENAME_MACHINEGUN = ++entityStateID;
CS_CurlyMachineGun::CS_CurlyMachineGun()
{
	stateID = CS_CurlySTATENAME_MACHINEGUN;
	cd_counter = 0;
	cd_counter_max = 7;
	iconIndex = 0;
}

const wchar_t* CS_CurlyMachineGun::GetSaveName()
{
	return L"MachineGun";
}

void CS_CurlyMachineGun::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	bUIShowDisableSkill = !(
		mychar->lastGun != this &&
		!lock
		);
	bool a1 = mychar->lastGun != this &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ӵ
	fcounter = (float)ammo_count / ammo_count_max;
	//ӵľЧʱ
	if (outOfAmmo_counter > 0)
		outOfAmmo_counter--;
	//ӵָ
	if (!we->input.GetAtk())
	{
		if (shootingToRefill_counter > 0)
			shootingToRefill_counter--;
		if (shootingToRefill_counter == 0)
		{
			ammoRefill_counter_max = 2;
			if (ammoRefill_counter > 0)
				ammoRefill_counter--;
			if (ammoRefill_counter == 0 && ammo_count < ammo_count_max)
			{
				ammo_count++;
				ammoRefill_counter = ammoRefill_counter_max;
			}
		}
	}
	if (ammo_count < ammo_count_max)
	{
		if (ammoBar.expired())
		{
			auto wammoBar = std::make_shared<PeReadyBar>(mychar, &fcounter, RGBA(0xff, 0xff, 0xff, 0xff), 0, -16,
				&CS_CurlyMachineGun::ReadyBar_Leave,
				&CS_CurlyMachineGun::ReadyBar_Destroy);
			ammoBar = wammoBar;
			we->gameFunc->SetEntity(we, wammoBar);
		}
	}
	EntitySkillState::SubStep();
}

void CS_CurlyMachineGun::ChangeStateMsg(int stateID)
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Curly>(we);

	if (stateID == GetStateID())
	{
		//ʼ
		enable = true;
		//лǹ
		mychar->lastGun = this;
		we->gameFunc->PlaySound(L"CS_004_switchweapon");
	}
	else if (stateID == CS_CurlySTATENAME_FIRE && cd_counter == 0 &&
		mychar->lastGun == this)
	{
		enable = false;
		//ӵ
		if (ammo_count > 0)
		{
			ammo_count--;
			shootingToRefill_counter = shootingToRefill_counter_max;
			//
			auto am = std::make_shared<CS_CurlyMachineGunBlade>(we);
			we->gameFunc->SetEntity(we, am);
			//ס
			cd_counter = cd_counter_max;
			//
			if (we->ud == 1)
			{
				if (we->vy > 0)
					we->vy /= 2.0f;
				if (we->vy - 1 > -2)
					we->vy--;
				else
					we->vy = -2;
			}
			else if (we->ud == -1)
			{
				if (we->vy + 0.5f < 2)
					we->vy += 0.5f;
				else
					we->vy = 2;
			}
		}
		else
		{
			if (outOfAmmo_counter == 0)
			{
				SetCS_PeOutOfAmmo(we, we->x, we->y);
				outOfAmmo_counter = outOfAmmo_counter_max;
				we->gameFunc->PlaySound(L"CS_037_gun_click");
			}
		}
	}
	else
		enable = false;
}

bool CS_CurlyMachineGun::ReadyBar_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return true;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	auto& skillMachineGun = mychar->skillMachineGun;
	bool bLeave = skillMachineGun.ammo_count == skillMachineGun.ammo_count_max;
	if (bLeave)
		skillMachineGun.ammoBar.reset();
	return bLeave;
}

void CS_CurlyMachineGun::ReadyBar_Destroy(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	auto& skillMachineGun = mychar->skillMachineGun;
	skillMachineGun.ammoBar.reset();
}
