#include "CS_CurlyEnergyShield.h"
#include "CS_Curly.h"
const int CS_CurlySTATENAME_SHIELD = ++entityStateID;
CS_CurlyEnergyShield::CS_CurlyEnergyShield()
{
	stateID = CS_CurlySTATENAME_SHIELD;
	cd_counter = 0;
	cd_counter_max = 30;
	iconIndex = 2;
	mp_cost = 1;
}

const wchar_t* CS_CurlyEnergyShield::GetSaveName()
{
	return L"EnergyShield";
}

void CS_CurlyEnergyShield::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	bUIShowDisableSkill = !(
		we->mp >= mp_cost &&
		!lock
		);

	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//άֻ
	if (bEnableShield)
	{
		if (we->gameFunc->ScriptIsRunning)
		{
			if (!we->gameFunc->ScriptIsRunning(we->gameFunc->gameScript))
			{
				if (shield_counter > 0)
					shield_counter--;
					
			}
		}
		else
		{
			if (shield_counter > 0)
				shield_counter--;
		}
		if (shield_counter == 0)
		{
			if (we->mp > 0)
			{
				//άֻ
				we->mp -= mp_cost;
				shield_counter = shield_counter_max;
			}
			else
			{
				//رջ
				cd_counter = cd_counter_max;
				auto wshield = shield.lock();
				if (wshield)
					wshield->SetLeave();
				shield.reset();
				bEnableShield = false;
			}
		}
	}
	if (cd_counter > 0)
		cd_counter--;
	if (cd_counter == 0)
	{
		int cdSrc = cd_counter;
		cd_counter = bEnableShield ? cd_counter_max : 0;
		EntitySkillState::SubStep();
		cd_counter = cdSrc;
	}
	else
	{
		EntitySkillState::SubStep();
	}
}

void CS_CurlyEnergyShield::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;
		if (bEnableShield)
		{
			//رջ
			//ȡܺһȴʱ
			cd_counter = cd_counter_max;
			auto wshield = shield.lock();
			if (wshield)
				wshield->SetLeave();
			shield.reset();
		}
		else
		{
			//򿪻
			//÷Ȧ
			auto wshield = std::make_shared<CS_CurlyEnergyShieldCircle>(we);
			shield = wshield;
			we->gameFunc->SetEntity(we, wshield);
			//û
			we->mp -= mp_cost;
			shield_counter = shield_counter_max;
		}
		//л
		bEnableShield = !bEnableShield;
		//ס
		we->inputLock.key |= keyMask;
	}
	else
		enable = false;
}

bool CS_CurlyEnergyShield::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	auto we = e.lock();
	if (!we)
		return false;
	auto mychar = std::static_pointer_cast<CS_Curly>(we);

	if (mychar->skillEnergyShield.bEnableShield)
	{
		//ɹ
		*outRealDamage = 0;
		return true;
	}
	return false;
}
