#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_CurlyWater.h"
#include "CS_CurlyDrown.h"
#include "CS_CurlyControl.h"
#include "CS_CurlyResist.h"
#include "CS_CurlyJump.h"
#include "CS_CurlyStand.h"
#include "CS_CurlyMove.h"
#include "CS_CurlyAir.h"
#include "CS_CurlyFaceToBack.h"
#include "CS_CurlyHurt.h"
#include "CS_CurlyBooster.h"
#include "CS_CurlyFire.h"
#include "CS_CurlyMachineGun.h"
#include "CS_CurlyNemesis.h"
#include "CS_CurlyEnergyShield.h"
#define CS_CURLY_CREATENAME L"CS_mychar_curly"
class CS_Curly :
    public MyCharEntity
{
public:
    CS_Curly();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	//ͼʾ
	bool showGun = false;//ʾǹ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_CurlyWater stateWater;
	CS_CurlyDrown stateDrown;
	CS_CurlyControl stateControl;
	CS_CurlyResist stateResist;
	CS_CurlyJump stateJump;
	CS_CurlyStand stateStand;
	CS_CurlyMove stateMove;
	CS_CurlyAir stateAir;
	CS_CurlyFaceToBack stateFaceToBack;
	CS_CurlyHurt stateHurt;
	CS_CurlyBooster stateBooster;
	//ģ
	EntitySkillState* lastGun = nullptr;
	CS_CurlyFire skillFire;
	CS_CurlyMachineGun skillMachineGun;
	CS_CurlyNemesis skillNemesis;
	CS_CurlyEnergyShield skillEnergyShield;
	//
	std::wstring crushEvent;
private:
	void GunAnimate();//
};

std::shared_ptr<Entity> CreateCS_Curly();