#include "CS_ChakoAni.h"

CS_ChakoAni::CS_ChakoAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_ChakoAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_ChakoAni::Step()
{
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_ChakoAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			{
				vx = 0;
				const wchar_t* move = L"";
				if (ud == -1)
					move = lr == 0 ? L"mc_chako_stand_lu" : L"mc_chako_stand_ru";
				else
					move = lr == 0 ? L"mc_chako_stand_l" : L"mc_chako_stand_r";
				ani.sprite_index = move;
			}
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				const wchar_t* move = L"";
				if (ud == -1)
					move = lr == 0 ? L"mc_chako_move_lu" : L"mc_chako_move_ru";
				else
					move = lr == 0 ? L"mc_chako_move_l" : L"mc_chako_move_r";
				ani.sprite_index = move;
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_chako_back_l" : L"mc_chako_back_r";
			break;
		}
	}

}

void CS_ChakoAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
	{
		ud = 0;
		SetState(0, lr);
	}
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"look_up")
	{
		ud = -1;
		SetState(stateID, lr);
	}
	else if (stateName == L"jump")
		vy = -0x300 / ts;
	else if (stateName == L"drawBefore")
		drawBeforeOtherEntity = lr == 1;
}

std::shared_ptr<Entity> CreateCS_ChakoAni()
{
	return std::make_shared<CS_ChakoAni>();
}
