#include "CS_Boss_TapPress.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Boss_TapPress::CS_Boss_TapPress(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.ignoreMovePlatform = true;
	cbRect.left = cbRect.right = 72;
	cbRect.bottom = 8;
	cbRect.top = 88;
	hp_max = hp = 16 * 15;
	dropExp = 99;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_tappress";
	//
	speedDir = true;
	bFall = true;
}

void CS_Boss_TapPress::Step()
{
	if (bFall)
		vy = 0x800 / ts;
	if (cbRect.cbBottom && bFall)
	{
		gameFunc->PlaySound(L"CS_035_explosion1");
		bFall = false;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

bool CS_Boss_TapPress::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage < 5)
	{
		*outRealDamage = 0;
		return true;
	}
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		cbRect.enableMovePlatform = false;
		cbRect.enableSelfSoild = false;
		//Ʒ
		SetExp();
		Destroy();
		return true;
	}
	*outRealDamage = getDamage;
	if (bFall)
		y -= 0x4000 / ts;
	return true;
}

void CS_Boss_TapPress::SetExp()
{
	float offy = y - (cbRect.bottom + cbRect.top) / 2;
	for (int i = 0; i < dropExp; i++)
	{
		auto e = std::make_shared<CS_Exp>();
		e->x = x;
		e->y = offy;
		e->SetSize(0);
		e->SetState(1, 0);//ٶȳʼ
		e->SetState(L"unlimit_speed", 0);
		float radian = Random(180, 360) * deg2rad;
		float force = Random(0x100, 0x1000) / ts;
		e->vx = force * cosf(radian);
		e->vy = force * sinf(radian);
		gameFunc->SetEntity(shared_from_this(), e);
	}
	//float offy = y - (cbRect.bottom + cbRect.top) / 2;
	//int smallNum, mediumNum, largeNum;
	//largeNum = dropExp / 20;
	//mediumNum = (dropExp % 20) / 5;
	//smallNum = (dropExp % 20) % 5;
	//for (int i = 0; i < smallNum; i++)
	//{
	//	auto e = std::make_shared<CS_Exp>();
	//	e->x = x;
	//	e->y = offy;
	//	e->SetSize(0);
	//	e->SetState(1, 0);//ٶȳʼ
	//	float radian = Random(180, 360) * deg2rad;
	//	float force = Random(0x800, 0x1000) / ts;
	//	e->vx = force * sinf(radian);
	//	e->vy = force * cosf(radian);
	//	gameFunc->SetEntity(shared_from_this(), e);
	//}
	//for (int i = 0; i < mediumNum; i++)
	//{
	//	auto e = std::make_shared<CS_Exp>();
	//	e->x = x;
	//	e->y = offy;
	//	e->SetSize(1);
	//	e->SetState(1, 0);//ٶȳʼ
	//	float radian = Random(180, 360) * deg2rad;
	//	float force = Random(0x800, 0x1000) / ts;
	//	e->vx = force * sinf(radian);
	//	e->vy = force * cosf(radian);
	//	gameFunc->SetEntity(shared_from_this(), e);
	//}
	//for (int i = 0; i < largeNum; i++)
	//{
	//	auto e = std::make_shared<CS_Exp>();
	//	e->x = x;
	//	e->y = offy;
	//	e->SetSize(2);
	//	e->SetState(1, 0);//ٶȳʼ
	//	float radian = Random(180, 360) * deg2rad;
	//	float force = Random(0x800, 0x1000) / ts;
	//	e->vx = force * sinf(radian);
	//	e->vy = force * cosf(radian);
	//	gameFunc->SetEntity(shared_from_this(), e);
	//}
}
