#include "CS_Boss_TapDmgRect.h"
#include "CS_Boss_Tap.h"
CS_Boss_TapDmgRect::CS_Boss_TapDmgRect(std::shared_ptr<CS_Boss_Tap> parent)
{
	type = 2;
	attackParent = tap = parent;
	lr = parent->lr;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Boss_TapDmgRect::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wtap = tap.lock();
	if (!wtap)
		return;

	if (!wtap->bAction)
		return;
	if (wtap->hp <= 0)
		return;
	*outDamage = damage;
	if (wtap->lr == 0)
	{
		*outAngle = 225;
	}
	else
	{
		*outAngle = 315;
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x600 / ts;
	*outHeavy = 2;
}

bool CS_Boss_TapDmgRect::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	//˺תƵ
	auto wtap = tap.lock();
	if (wtap)
	{
		wtap->bHurtBlock = false;//˺
		bool ret = wtap->Hurt(src, getDamage, angle, bTakedown, elemType, shockForce, heavy, outRealDamage);
		wtap->bHurtBlock = true;//ر˺
		return ret;
	}
	return false;
}
