#include "CS_Boss_RedDemon.h"
#include "CS_AmRedDemon.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Boss_RedDemon::CS_Boss_RedDemon()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 18;
	cbRect.bottom = 12;

	hp_max = hp = 500;
	dropExp = 19;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Boss_RedDemon::Init(std::weak_ptr<Entity> self)
{
	y -= 4;
	Entity::Init(self);
}

void CS_Boss_RedDemon::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		vx = 0;
		act_no = 2;
		ani_no = 0;
		[[fallthrough]];
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
				lr = x > wplayer->x ? 0 : 2;
		}
		if (++ani_wait > 20)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		//if (shock_counter > 0)
		//	act_no = 10;
		break;
	case 10:
		act_no = 11;
		act_wait = 0;
		ani_no = 3;
		bShootable = true;
		[[fallthrough]];
	case 11:
		switch (++act_wait)
		{
		case 30:
		case 40:
		case 50:
			ani_no = 4;
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					float dy = 0;
					XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - (y + dy), 0, 0));
					SetCS_AmRedDemon(shared_from_this(), x, y + dy, 4 * XMVectorGetX(vec), 4 * XMVectorGetY(vec));
					gameFunc->PlaySound(L"CS_039_em_fire");
				}
			}
			break;
		case 34:
		case 44:
		case 54:
			ani_no = 3;
			break;
		}
		if (act_wait > 60)
		{
			act_no = 20;
			act_wait = 0;
			ani_no = 2;
		}
		break;
	case 20:
		if (++act_wait > 20)
		{
			act_no = 21;
			act_wait = 0;
			ani_no = 5;
			vy = -0x900 / ts;
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				float dashSpeed = Random(0x50, 0x400) / ts;
				if (wplayer)
					vx = x < wplayer->x ? dashSpeed : -dashSpeed;
			}
		}
		break;
	case 21:
		switch (++act_wait)
		{
		case 30:
		case 40:
		case 50:
		case 60:
		case 70:
		case 80:
			ani_no = 6;
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					float dy = -0x1400 / ts;
					//ֱ
					float dx1 = wplayer->x - x;
					float dy1 = wplayer->y - (y + dy);
					auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx1, dy1, 0, 0))));
					if (dy1 < 0)
						angle = 360 - angle;
					angle += Random(-30, 30);
					float radian = angle * deg2rad;
					SetCS_AmRedDemon(shared_from_this(), x, y + dy, 4 * cosf(radian), 4 * sinf(radian));
					gameFunc->PlaySound(L"CS_039_em_fire");
				}
			}
			break;
		case 34:
		case 44:
		case 54:
		case 64:
		case 74:
			ani_no = 5;
			break;
		}
		if (act_wait > 53)
			ani_no = 7;
		if (cbRect.cbBottom)
		{
			act_no = 22;
			act_wait = 0;
			ani_no = 2;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			gameFunc->PlaySound(L"CS_026_quake");
		}
		break;
	case 22:
		vx /= 2;
		if (++act_wait > 22)
			act_no = 10;
		break;
	case 50:
		bShootable = false;
		if (cbRect.cbBottom)
		{
			act_no = 51;
			ani_no = 2;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			SetCS_Exp(shared_from_this(), x, y, dropExp);
			SetCS_PeSmokeMedium(shared_from_this(), x, y);
			gameFunc->PlaySound(L"CS_072_big_crash");
		}
		break;
	case 51:
		vx = 7 * vx / 8;
		ani_no = 8;
		break;
	}
	vy += 0x20 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (act_no < 50)
	{
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
				lr = x < wplayer->x ? 1 : 0;
		}
	}
	ani.sprite_index = lr == 0 ? L"ls_reddemon_l" : L"ls_reddemon_r";
}

void CS_Boss_RedDemon::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_reddemon_l" : L"ls_reddemon_r";
}

void CS_Boss_RedDemon::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"fight")
		SetState(10, lr);
}

void CS_Boss_RedDemon::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp <= 0)
		return;
	if (!bShootable)
		return;
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Boss_RedDemon::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (hp <= 0)
		return false;
	if (!bShootable)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	if (hp <= 0)
	{
		act_no = 50;
		hp = 0;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Boss_RedDemon()
{
	return std::make_shared<CS_Boss_RedDemon>();
}
