#include "CS_Boss_ControlCore.h"
#include "CS_PeSmoke.h"
CS_Boss_ControlCore::CS_Boss_ControlCore()
{
	hp = hp_max = 400;
	change_counter = change_counter_max = 600;
	ignoreCaught = true;
}

void CS_Boss_ControlCore::Step()
{
	if (bFindEntity)
	{
		bFindEntity = false;
		for (auto & am : entityLayer->Am)
		{
			if (!am)
				continue;
			if (am->el.name == CS_BOSS_HONEYCOMB_CREATENAME)
			{
				auto whoneycomb = std::static_pointer_cast<CS_Boss_Honeycomb>(am);
				honeycomb = whoneycomb;
				whoneycomb->controlCore = shared_from_this();
			}	
			else if (am->el.name == CS_BOSS_DEMONFLOWER_CREATENAME)
			{
				auto wdemonflower = std::static_pointer_cast<CS_Boss_DemonFlower>(am);
				demonflower = wdemonflower;
				wdemonflower->controlCore = shared_from_this();
			}
			if (honeycomb.lock() && demonflower.lock())
				break;
		}
	}
	if (!bBoot)
		return;
	
	auto whoneycomb = honeycomb.lock();
	auto wdemonflower = demonflower.lock();
	if (!whoneycomb || !wdemonflower)
		return;
	if (secondForm)
	{
		//ڶ̬
		if (sleep_counter > 0)
		{
			sleep_counter--;
			if (sleep_counter == 0)
			{
				//ȫ
				auto wdemonflower = demonflower.lock();
				wdemonflower->SetState(L"secondState", 0);
				wdemonflower->SetState(L"open", 0);
				demonflower_open = true;
				whoneycomb->SetState(L"secondState", 0);
				whoneycomb->SetState(L"open", 0);
				honeycomb_open = true;
			}
		}
	}
	else
	{
		//һ̬
		if (hp <= hp_max / 2)
		{
			//ȫرһ
			if (honeycomb_open)
			{
				whoneycomb->SetState(L"close", 0);
				honeycomb_open = false;
			}
			if (demonflower_open)
			{
				wdemonflower->SetState(L"close", 0);
				demonflower_open = false;
			}
			sleep_counter = 500;
			secondForm = true;
		}
		if (change_counter > 0)
			change_counter--;
		if (change_counter <= 0)
		{
			change_counter = change_counter_max;
			//л䳲ͻ
			if (honeycomb_open)
			{
				whoneycomb->SetState(L"close", 0);
				honeycomb_open = false;
				wdemonflower->SetState(L"open", 0);
				demonflower_open = true;
			}
			else
			{
				wdemonflower->SetState(L"close", 0);
				demonflower_open = false;
				whoneycomb->SetState(L"open", 0);
				honeycomb_open = true;
			}
		}
	}
}

void CS_Boss_ControlCore::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"boot")
	{
		auto whoneycomb = honeycomb.lock();
		auto wdemonflower = demonflower.lock();
		if (whoneycomb && wdemonflower)
		{
			bBoot = true;
			whoneycomb->SetState(L"open", 0);
			honeycomb_open = true;
		}
	}
}

bool CS_Boss_ControlCore::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (hp == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	change_counter -= getDamage * 10;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		auto whoneycomb = honeycomb.lock();
		auto wdemonflower = demonflower.lock();
		hp = 0;
		if (whoneycomb)
			whoneycomb->SetState(L"defeated", 1);
		if (wdemonflower)
			wdemonflower->SetState(L"defeated", 1);
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_Boss_ControlCore()
{
	return std::make_shared<CS_Boss_ControlCore>();
}
