#include "CS_Boss_Arowana.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeWaterDrop.h"
#include "CS_FallRock_Locator.h"
#include "CS_PeGunShotHit.h"
#include "PeLightTail.h"
CS_Boss_Arowana::CS_Boss_Arowana()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ʵ
	cbRect.left = 24;
	cbRect.right = 24;
	cbRect.bottom = cbRect.top = 8;
	//
	hp_max = hp = 100;
	hp = 100;
	//
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	caughtDifficulty = 0.8f;
	//
	ignoreTrap = true;
	bSetLightTail = true;
}

void CS_Boss_Arowana::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Boss_Arowana::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
	face = 3;
	AnimateStep();
}

void CS_Boss_Arowana::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"set_player_type")
		type = 1;
	if (stateName == L"hide")
	{
		hide = true;
		auto wpeDizzy = peDizzy.lock();
		if (wpeDizzy)
			wpeDizzy->hide = true;
	}
}

void CS_Boss_Arowana::Step()
{
	if (cbRect.inWater)
		drawBeforeOtherEntity = false;
	else
		drawBeforeOtherEntity = true;
	if (hp == 0)
	{
		ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
		face = 2;
		bShowDizzy = true;
		cbRect.left = 24;
		cbRect.right = 24;
		cbRect.bottom = cbRect.top = 8;
		cbRect.enableSoild = true;
		AnimateStep();
		if (bCaught)
			return;
		stateGravity.Step();
		stateResist.Step();
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
		return;
	}
	if (bCaught)
	{
		vx = vy = 0;
		ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
		face = 1;
	}
	else
	{
		if (flee_counter > 0)
			flee_counter--;
		switch (stateID)
		{
		case 0://ٿʼײ
			DashStep();
			break;
		case 1://ˮ
			FallToWaterStep();
			break;
		case 2://Ӿ
			SwimStep();
			break;
		case 3://Ծ׶
			JumpStep();
			break;
		}
	}
	//޵֡
	if (flee_counter > 0)
	{
		if (flee_counter / 2 % 2 == 0)
			color = RGBA(0xff, 0xff, 0xff, 0x40);
		else
			color = RGBA(0xff, 0xff, 0xff, 0xc0);
	}
	else
	{
		color = RGBA(0xff, 0xff, 0xff, 0xff);
	}
	AnimateStep();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Boss_Arowana::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp == 0)
		return;
	if (hp > 20 || cbRect.inWater)
		*outDamage = 4;
	else
		return;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Boss_Arowana::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (!cbRect.inWater)
	{
		*outRealDamage = 0;
		return true;
	}
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		stateID = 1;
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
	}
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<Entity> CS_Boss_Arowana::BeginCaught(std::weak_ptr<Entity> e)
{
	//ҵͬһ
	if (stateID != 2)
		return std::weak_ptr<Entity>();
	if (bCaught)
		return  std::weak_ptr<Entity>();
	if (flee_counter > 0)
		return  std::weak_ptr<Entity>();
	if (!cbRect.inWater)
		return  std::weak_ptr<Entity>();
	gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	bCaught = true;
	return shared_from_this();
}

void CS_Boss_Arowana::EndCaught(std::weak_ptr<Entity> e)
{
	bCaught = false;
	flee_counter = 180;
}

void CS_Boss_Arowana::Destroy()
{
	auto wpeDizzy = peDizzy.lock();
	if (wpeDizzy)
		wpeDizzy->Destroy();
	Entity::Destroy();
}

void CS_Boss_Arowana::AnimateStep()
{
	auto wpeDizzy = peDizzy.lock();
	if (!wpeDizzy && gameFunc)
	{
		peDizzy = wpeDizzy = std::make_shared<CS_PeDizzy>(shared_from_this());
		gameFunc->SetEntity(shared_from_this(), wpeDizzy);
	}
	if (wpeDizzy)
		wpeDizzy->hide = !bShowDizzy;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);
	switch (face)
	{
	case 0://
		ani.hideLayerList.erase(4);
		ani.hideLayerList.erase(5);
		break;
	case 1://
		ani.hideLayerList.erase(3);
		ani.hideLayerList.erase(6);
		break;
	case 2://ѣ
		ani.hideLayerList.erase(2);
		ani.hideLayerList.erase(6);
		break;
	case 3://
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.erase(6);
		break;
	}
}

void CS_Boss_Arowana::DashStep()
{
	face = 3;
	const float dashMaxSpeed = 0x900 / ts;
	const float dashAcc = 0x80 / ts;
	vy = 0;
	if (bSetLightTail)
	{
		bSetLightTail = false;
		SetLightTail();
	}
	//ֱײǽ
	if (lr == 0)
	{
		if (vx - dashAcc > -dashMaxSpeed)
			vx -= dashAcc;
		else
			vx = -dashMaxSpeed;
		if (cbRect.cbLeft && stateID == 0)
		{
			SetQuake();
			//лײ״̬
			stateID = 1;
			vy = -0x400 / ts;
		}
	}
	else
	{
		if (vx + dashAcc < dashMaxSpeed)
			vx += dashAcc;
		else
			vx = dashMaxSpeed;
		if (cbRect.cbRight && stateID == 0)
		{
			SetQuake();
			//лײ״̬
			stateID = 1;
			vy = -0x400 / ts;
		}
	}
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
}

void CS_Boss_Arowana::FallToWaterStep()
{
	//ӵ
	cbRect.enableSoild = false;
	//Ծ
	if (lr == 0)
	{
		vx = 0x200 / ts;
	}
	else
	{
		vx = -0x200 / ts;
	}
	cbRect.left = 8;
	cbRect.right = 8;
	cbRect.bottom = cbRect.top = 24;
	if (vy < 0)
		stateGravity.SetGravityScale(0.4f);
	else
		stateGravity.SetGravityScale(1);
	stateGravity.Step();
	ani.sprite_index = lr == 0 ? L"ls_arowana_jump_l" : L"ls_arowana_jump_r";
	face = 0;
	//ˮУתȥӾ״̬
	if (cbRect.inWater && cbRect.cbBottom)
	{
		stateID = 2;
		//һ
		lr = lr == 0 ? 1 : 0;
		SearchJumpPlace();
	}
}

void CS_Boss_Arowana::SwimStep()
{
	//Ӿ׶
	cbRect.enableSoild = false;
	cbRect.left = 24;
	cbRect.right = 24;
	cbRect.bottom = cbRect.top = 8;
	vy = 0;
	int X = (int)(x / 16);
	int Y = (int)(y / 16);
	if (X == targetX)
	{
		if (Random(0, 100) < 50 && flee_counter == 0)
		{
			SearchJumpPlace();
		}
		else
		{
			//εĿ꣬ȥԾ׶
			stateID = 3;
			cbRect.enableSoild = true;
		}
	}
	else
	{
		float speed = 0x500 / ts;
		if (X > targetX)
			vx = -speed;
		else
			vx = speed;
		if (vx < 0)
			lr = 0;
		else
			lr = 1;
	}
	face = 0;
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
}

void CS_Boss_Arowana::JumpStep()
{
	cbRect.enableSoild = false;
	//ȡ
	if (!gameFunc->GetPlayerDistance)
		return;
	auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
	if (!wplayer)
		return;
	//һĸ߶
	if (y > wplayer->y)
		vy = -1800 / ts;
	else
	{
		//߶
		//صײ״̬
		if (wplayer->x > x)
			lr = 1;
		else
			lr = 0;
		cbRect.enableSoild = true;
		stateID = 0;
		bSetLightTail = true;
	}
	vx = 0;
	ani.sprite_index = L"la_arowana_waterjump";
}

void CS_Boss_Arowana::SetQuake()
{
	//Ļ
	gameFunc->PlaySound(L"CS_071_little_crash");
	SetCS_PeSmokeMedium(shared_from_this(), x, y);
	if (gameFunc->SetQuake)
		gameFunc->SetQuake(gameFunc->game, 30, 0);
	//return;
	//ʯ
	//һηеʯλ
	auto& roomRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
	std::list<std::shared_ptr<Entity>>* pLs = nullptr;
	for (auto& p : roomRes)
	{
		if (p.first->layerType == 0)
		{
			pLs = &p.second.Ls;
			break;
		}
	}
	if (pLs)
	{
		for (auto& e : *pLs)
			if (e->el.name == CS_FALLROCK_LOCATOR_CREATENAME)
				e->SetState(L"fallrock", 0);
	}
}

void CS_Boss_Arowana::SearchJumpPlace()
{
	//ҸҴֱչԼxλýֱ߲
	targetX = -1;
	jumpX.clear();
	//1.ѡһĿ
	std::weak_ptr<Entity> player;
	auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
	std::vector<std::weak_ptr<Entity>> tempArr;
	for (auto& p : allPlayer)
	{
		auto we = p.second.lock();
		if (we)
		{
			if (we->el.name.length() == 0)
				continue;
			if (we->el.name == L"null")
				continue;
			tempArr.push_back(we);
		}
	}
	if (tempArr.size() == 1)
	{
		player = tempArr.front();
	}
	else
	{
		int index = Random(0, (int)(tempArr.size() - 1));
		player = tempArr[index];
	}
	int mapW, mapH;
	gameFunc->GetMapSize(gameFunc->mapSizeGetter, &mapW, &mapH);
	//2.Ըҵĸ
	//ѰĿԾ
	auto wplayer = player.lock();
	if (wplayer)
	{
		int startPos = (int)(wplayer->x / 16);
		//Լxλýֱ߲
		for (int X = startPos; X >= 0; X--)
			if (!gameFunc->LineTest(shared_from_this(), (float)X, y / 16, (float)X, wplayer->y / 16))//ֱ߲
				jumpX.push_back(X);
		//ѰҲĿԾ
		for (int X = startPos; X < mapW; X++)
			if (!gameFunc->LineTest(shared_from_this(), (float)X, y / 16, (float)X, wplayer->y / 16))//ֱ߲
				jumpX.push_back(X);
	}
	//ѡһ뵱ǰλ5xԾ
	for (auto X : jumpX)
		if (abs(X - x / 16) >= 5)
			targetX = X;
}

bool CS_Boss_Arowana::LightTail_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (we)
	{
		auto _this = std::static_pointer_cast<CS_Boss_Arowana>(we);
		return _this->stateID != 0;
	}
	return true;
}

void CS_Boss_Arowana::SetLightTail()
{
	//Ч
	auto nE = std::make_shared<PeLightTail>(shared_from_this(), 80, 16);
	nE->SetLeaveFunc(&CS_Boss_Arowana::LightTail_Leave);
	gameFunc->SetEntity(shared_from_this(), nE);
}

std::shared_ptr<Entity> CreateCS_Boss_Arowana()
{
	return std::make_shared<CS_Boss_Arowana>();
}
