#include "CS_ArowanaAni.h"
#include "CS_PeSmoke.h"

CS_ArowanaAni::CS_ArowanaAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = 24;
	cbRect.right = 24;
	cbRect.bottom = cbRect.top = 8;
	drawBeforeOtherEntity = true;
}

void CS_ArowanaAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	auto wpeDizzy = std::make_shared<CS_PeDizzy>(shared_from_this());
	peDizzy = wpeDizzy;
	gameFunc->SetEntity(shared_from_this(), wpeDizzy);
	Entity::Init(self);
}

void CS_ArowanaAni::Step()
{
	switch (stateID)
	{
	case 0://
		cbRect.left = 24;
		cbRect.right = 24;
		cbRect.bottom = cbRect.top = 8;
		ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
		break;
	case 1://µ
		cbRect.left = 8;
		cbRect.right = 8;
		cbRect.bottom = cbRect.top = 8;
		ani.sprite_index = lr == 0 ? L"ls_arowana_fallen_l" : L"ls_arowana_fallen_r";
		break;
	case 2://վ
		cbRect.left = 24;
		cbRect.right = 24;
		cbRect.bottom = cbRect.top = 8;
		ani.sprite_index = lr == 0 ? L"ls_arowana_stand_l" : L"ls_arowana_stand_r";
		break;
	case 3://Ծ
		ani.sprite_index = lr == 0 ? L"ls_arowana_stand_l" : L"ls_arowana_stand_r";
		if (cbRect.cbBottom && bSetQuake)
		{
			bSetQuake = false;
			gameFunc->SetQuake(gameFunc->game, 30, 0);
			gameFunc->PlaySound(L"CS_026_quake");
		}
		break;
	}
	stateGravity.Step();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	AnimateStep();
}

void CS_ArowanaAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		switch (stateID)
		{
		default:
		case 0:
			ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
			AnimateStep();
			break;
		}
	}
	else
	{
	}
}

void CS_ArowanaAni::SetState(std::wstring stateName, int lr)
{
	this->lr = lr;
	if (stateName == L"normal")
	{
		stateID = 0;
		bShowDizzy = false;
		face = 0;
	}
	else if (stateName == L"dizzy")
	{
		stateID = 0;
		bShowDizzy = true;
		face = 2;
	}
	else if (stateName == L"fallen")
	{
		stateID = 1;
		bShowDizzy = true;
		face = 0;
	}
	else if (stateName == L"wake")
	{
		stateID = 1;
		bShowDizzy = false;
		face = 0;
	}
	else if (stateName == L"stand")
	{
		stateID = 2;
		bShowDizzy = false;
		face = 0;
	}
	else if (stateName == L"makeSmoke")
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
	}
	else if (stateName == L"jump")
	{
		stateID = 3;
		bSetQuake = true;
		vy = -2;
	}
	else if (stateName == L"angry")
	{
		face = 3;
	}
}

void CS_ArowanaAni::Destroy()
{
	auto wpeDizzy = peDizzy.lock();
	if (wpeDizzy)
		wpeDizzy->Destroy();
	Entity::Destroy();
}

void CS_ArowanaAni::AnimateStep()
{
	auto wpeDizzy = peDizzy.lock();
	if (wpeDizzy)
		wpeDizzy->hide = !bShowDizzy;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);
	switch (face)
	{
	case 0://
		ani.hideLayerList.erase(4);
		ani.hideLayerList.erase(5);
		break;
	case 1://
		ani.hideLayerList.erase(3);
		ani.hideLayerList.erase(6);
		break;
	case 2://ѣ
		ani.hideLayerList.erase(2);
		ani.hideLayerList.erase(6);
		break;
	case 3://
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.erase(6);
		break;
	}
}

std::shared_ptr<Entity> CreateCS_ArowanaAni()
{
	return std::make_shared<CS_ArowanaAni>();
}
