#include "CS_AmTornado.h"
#include "PeSpark.h"
CS_AmTornado::CS_AmTornado(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ùλ
	ud = parent->ud;
	lr = parent->lr;
	auto dx = lr == 0 ? -8.0f : 8.0f;
	x = parent->x + dx;
	y = parent->y;
	//ٶ
	auto move = 0x200 / ts;
	vx = lr == 0 ? -move : move;
	//ö
	ani.sprite_index = L"am_tornado_appear";
	//ʱ
	boot_counter = 8;
	appear_counter = 24;
	disappear_counter = disappear_counter_max = 30;
	action_timecounter = action_timecounter_max = 300;
	//þο
	cbRect.left = 0;
	cbRect.right = 0;
	cbRect.top = 0;
	cbRect.bottom = 0;
	//ι
	damaged_limit = 12;//๥12
	damage_reset_counter = 8;
	attackState_reset_counter_max = 8;
}

void CS_AmTornado::Step()
{
	//ʱ
	if (boot_counter > 0)
	{
		boot_counter--;
		return;
	}
	//ʱ
	if (appear_counter > 0)
	{
		appear_counter--;
		if (appear_counter == 0)
		{
			//þο
			cbRect.left = 16;
			cbRect.right = 16;
			cbRect.top = 72;
			cbRect.bottom = 8;
			ani.sprite_index = L"am_tornado";
			ani.image_index = 0;
		}
	}
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ִ˶
	Entity::Step();
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
			bLeave = true;
	}
	if(damaged_limit == damaged_counter)
		bLeave = true;
	if (bLeave)
	{
		if (disappear_counter > 0)
		{
			disappear_counter--;
			if (disappear_counter == 0)
				inUsing = false;
		}
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(0xff * disappear_counter / disappear_counter_max));
	}
}

void CS_AmTornado::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		//ѵ
		if (x > wdst->x)
			*outAngle = 0;
		else
			*outAngle = 180;
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 1;
}

void CS_AmTornado::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage > 0)
	{
		auto pe = gameFunc->GameCreateEntity(L"pe_blade");
		pe->x = x;
		pe->y = y;
		gameFunc->SetEntity(shared_from_this(), pe);
		SetPeSpark(shared_from_this(), centerX, centerY, 1, 3, lr == 0 ? 180.0f : 0);
		//
		gameFunc->PlaySound(L"AMBlade");
	}
}
