#include "CS_AmBubbleBeamCharge.h"
CS_AmBubbleBeamCharge::CS_AmBubbleBeamCharge(std::shared_ptr<Entity> parent, DWORD keyMask, int level,
	void(*AddToAmList)(std::weak_ptr<Entity>, std::weak_ptr<CS_AmBubbleBeam>),
	void(*RemoveFromAmList)(std::weak_ptr<Entity>, std::weak_ptr<CS_AmBubbleBeam>))
{
	type = 3;
	attackParent = parent;
	this->keyMask = keyMask;
	this->level = level;
	this->AddToAmList = AddToAmList;
	this->RemoveFromAmList = RemoveFromAmList;
	lr = parent->lr;

	float dx = lr == 0 ? -8.0f : 8.0f;
	x = parent->x + dx;
	last_x = parent->last_x + dx;
	y = parent->y;
	last_y = parent->last_y;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_bubblebeam_charge_begin";
}

void CS_AmBubbleBeamCharge::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		if (!bShot)
		{
			bool bPressedKey = wattackParent->input.key & keyMask;
			if (!bPressedKey)
			{
				//
				bShot = true;
				auto am = std::make_shared<CS_AmBubbleBeam>(wattackParent, level, RemoveFromAmList);
				am->x = x;
				am->last_x = last_x;
				am->y = y;
				am->last_y = last_y;
				am->vx = lr == 0 ? -shotSpeed : shotSpeed;
				gameFunc->SetEntity(wattackParent, am);
				gameFunc->PlaySound(L"CS_bubblebeam");
				AddToAmList(wattackParent, am);
				if (charge_counter == 0)
				{
					shot_counter = 10;
				}
				else
				{
					Destroy();
					return;
				}
			}
		}
	}
	else
	{
		Destroy();
		return;
	}
	if (bShot)
	{
		if (shot_counter > 0)
			shot_counter--;
		if (shot_counter % 5 == 0)
		{
			auto am = std::make_shared<CS_AmBubbleBeam>(wattackParent, level, RemoveFromAmList);
			am->x = x;
			am->last_x = last_x;
			am->y = y;
			am->last_y = last_y;
			float angle;
			float dA = 15;
			if (lr == 0)
			{
				if (shot_counter == 0)
					angle = 180 - dA;
				else
					angle = 180 + dA;
			}
			else
			{
				if (shot_counter == 0)
					angle = dA;
				else
					angle = 360 - dA;
			}
			am->vx = shotSpeed * cosf(angle * deg2rad);
			am->vy = shotSpeed * sinf(angle * deg2rad);
			gameFunc->SetEntity(wattackParent, am);
			gameFunc->PlaySound(L"CS_bubblebeam");
			AddToAmList(wattackParent, am);
		}
		if (shot_counter == 0)
			Destroy();
	}
	else
	{
		if (charge_counter > 0)
		{
			charge_counter--;
			if (charge_counter == 0)
			{
				gameFunc->PlaySound(L"CS_bubblebeam_charge_on");
			}
		}
		ani.sprite_index = charge_counter == 0 ? L"pe_bubblebeam_charge_end" : L"pe_bubblebeam_charge_begin";
	}
	lr = wattackParent->lr;
	float dx = lr == 0 ? -8.0f : 8.0f;
	x = wattackParent->x + dx;
	last_x = wattackParent->last_x + dx;
	y = wattackParent->y;
	last_y = wattackParent->last_y;
}
