#include "TranslateLua.h"
#include "main.h"
const luaL_Reg translateFuncList[] =
{
	{"AddRoomNameTable", LuaFunc_AddRoomNameTable},
	{"AddSoundTable", LuaFunc_AddSoundTable},
	{"AddDrumTable", LuaFunc_AddDrumTable},
	{"SetPixelFont_Size12", SetPixelFont_Size12},
	{"SetPixelFont_Size14", SetPixelFont_Size14},
	{"SetHQFont", SetHQFont},
	{"SetMsgboxTextOffY", SetMsgboxTextOffY},
	{"SetMsgboxTextOffY_scale_x1", SetMsgboxTextOffY_scale_x1},
	{"SetFaceFile", SetFaceFile},
	{"SetFaceID", SetFaceID},
	{NULL, NULL},
};

int InitTranslateLua(lua_State* L)
{
	luaL_newlib(L, translateFuncList);
	return 1;
}

lua_State* NewTranslateLua()
{
	auto L = luaL_newstate();
	luaL_openlibs(L);
	luaL_requiref(L, "mylib", InitTranslateLua, 0);
	std::string cmd;
	char appendStr[MAX_PATH];
	sprintf_s(appendStr, "mylib = require(\"mylib\");\n");
	cmd.append(appendStr);
	for (auto& f : translateFuncList)
		if (f.name != NULL)
		{
			sprintf_s(appendStr, "%s = mylib.%s;\n", f.name, f.name);
			cmd.append(appendStr);
		}
	luaL_dostring(L, cmd.c_str());
	return L;
}

int LuaFunc_AddRoomNameTable(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"AddRoomNameTable(mapName,roomName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űAddRoomNameTable", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	std::vector<wchar_t> mapName_utf16;
	std::vector<wchar_t> roomName_utf16;
	UTF8ToUTF16(lua_tostring(L, 1), &mapName_utf16);
	UTF8ToUTF16(lua_tostring(L, 2), &roomName_utf16);
	auto iter = roomNameTable.find(mapName_utf16.data());
	if (iter != roomNameTable.end())
		roomNameTable.erase(iter);
	roomNameTable.insert(std::make_pair(mapName_utf16.data(), roomName_utf16.data()));
	return 0;
}

int LuaFunc_AddSoundTable(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"AddSoundTable(soundName,soundFile)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űAddSoundTable", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	auto src = lua_tostring(L, 1);
	auto dst = lua_tostring(L, 2);
	std::vector<wchar_t> srcbuff, dstbuff;
	UTF8ToUTF16(src, &srcbuff);
	UTF8ToUTF16(dst, &dstbuff);
	auto iter = soundTable.find(srcbuff.data());
	if (iter != soundTable.end())
		soundTable.erase(iter);
	soundTable.insert(std::make_pair(srcbuff.data(), dstbuff.data()));
	return 0;
}

int LuaFunc_AddDrumTable(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"AddDrumTable(index,drumName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űAddSoundTable", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	auto index = lua_tointeger(L, 1);
	auto drumName = lua_tostring(L, 2);
	std::vector<wchar_t> wbuff;
	UTF8ToUTF16(drumName, &wbuff);
	auto iter = drumTable.find((int)index);
	if (iter != drumTable.end())
		drumTable.erase(iter);
	drumTable.insert(std::make_pair(index, wbuff.data()));
	return 0;
}

int SetPixelFont_Size12(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetPixelFont_Size12(fontName,fontSize)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetPixelFont_Size12", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	pixelFont_size12 = lua_tostring(L, 1);
	pixelFont_size12_arg = (int)lua_tointeger(L, 2);
	return 0;
}

int SetPixelFont_Size14(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetPixelFont_Size14(fontName,fontSize)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetPixelFont_Size14", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	pixelFont_size14 = lua_tostring(L, 1);
	pixelFont_size14_arg = (int)lua_tointeger(L, 2);
	return 0;
}

int SetHQFont(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetHQFont(fontName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetHQFont", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	highQualityFont = lua_tostring(L, 1);
	return 0;
}

int SetMsgboxTextOffY(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetMsgboxTextOffY(y)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetMsgboxTextOffY", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	msgboxTextOffy = (float)lua_tonumber(L, 1);
	return 0;
}

int SetMsgboxTextOffY_scale_x1(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetMsgboxTextOffY_scale_x1(y)\nʵյΪ%d", argNum);
		MessageBoxW(nullptr, err, L"űSetMsgboxTextOffY_scale_x1", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	msgboxTextOffy_scale_x1 = (float)lua_tonumber(L, 1);
	return 0;
}

int SetFaceFile(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetFaceFile(faceFile,bInterArea=false)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetFaceFile", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	auto faceFile = lua_tostring(L, 1);
	std::vector<wchar_t> wbuff;
	UTF8ToUTF16(faceFile, &wbuff);
	if(argNum == 1)
		facefileTable.insert(std::make_pair(wbuff.data(), false));
	else if(argNum == 2)
		facefileTable.insert(std::make_pair(wbuff.data(), lua_toboolean(L, 2)));
	return 0;
}

int SetFaceID(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 6)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SetFaceID(faceID,faceFile,x,y,w,h])\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSetFaceID", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	FaceDisplayInfo info;
	std::vector<wchar_t> wbuff, wbuff2;
	auto faceID = lua_tostring(L, 1);
	auto faceFile = lua_tostring(L, 2);
	UTF8ToUTF16(faceID, &wbuff);
	UTF8ToUTF16(faceFile, &wbuff2);
	info.facefile = wbuff2.data();
	info.src.Set1((float)lua_tonumber(L, 3),
		(float)lua_tonumber(L, 4),
		(float)lua_tonumber(L, 5),
		(float)lua_tonumber(L, 6));
	faceIDTable.insert(std::make_pair(wbuff.data(), info));
	return 0;
}
