#include "SlotDrawer.h"

void SlotDrawer::Init(MyDX11Renderer* pRenderer, MyView* pView, EntityRes* pEntityRes)
{
	this->pRenderer = pRenderer;
	this->pView = pView;
	this->pEntityRes = pEntityRes;
}

void SlotDrawer::Reset()
{
	drawList.clear();
	loadedSlot.clear();
}

void SlotDrawer::Draw()
{
	for (auto& p : drawList)
	{
		auto iter = loadedSlot.find(p.name);
		if (iter == loadedSlot.end())
		{
			LoadedSlot slot = LoadSaveFileToSlot(p.name.c_str());
			loadedSlot.insert(std::make_pair(p.name, slot));
			DrawSlot(p.player1Icon, p.player2Icon, &slot);
		}
		else
			DrawSlot(p.player1Icon, p.player2Icon, &iter->second);
	}
}

void SlotDrawer::EnableDraw(bool bEnable)
{
	enbaleDraw = bEnable;
}

void SlotDrawer::AddDraw(std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon, const wchar_t* name)
{
	SlotDrawArg arg;
	arg.name = name;
	arg.player1Icon = player1Icon;
	arg.player2Icon = player2Icon;
	drawList.push_back(arg);
}

void SlotDrawer::DrawClear()
{
	drawList.clear();
}

void SlotDrawer::DrawSlot(std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon, const LoadedSlot* slot)
{
	auto wplayer1Icon = player1Icon.lock();
	auto wplayer2Icon = player2Icon.lock();
	if (slot->loadFail)
	{
		if (wplayer1Icon)
		{
			wplayer1Icon->ani.png.clear();
			wplayer1Icon->ani.sprite_index.clear();
			wplayer1Icon->ani.image_index = 0;
			wplayer1Icon->ani.hideLayerList.clear();
		}
		if (wplayer2Icon)
		{
			wplayer2Icon->ani.png.clear();
			wplayer2Icon->ani.sprite_index.clear();
			wplayer2Icon->ani.image_index = 0;
			wplayer2Icon->ani.hideLayerList.clear();
		}
		return;
	}
	if (wplayer1Icon)
	{
		wplayer1Icon->ani.png = slot->player1.png;
		wplayer1Icon->ani.sprite_index = slot->player1.spriteIndex;
		wplayer1Icon->ani.image_index = slot->player1.imageIndex;
		wplayer1Icon->ani.hideLayerList = slot->player1.hideLayerList;
	}
	if (wplayer2Icon)
	{
		wplayer2Icon->ani.png = slot->player2.png;
		wplayer2Icon->ani.sprite_index = slot->player2.spriteIndex;
		wplayer2Icon->ani.image_index = slot->player2.imageIndex;
		wplayer2Icon->ani.hideLayerList = slot->player2.hideLayerList;
	}
}

LoadedSlot SlotDrawer::LoadSaveFileToSlot(const wchar_t* name)
{
	LoadedSlot slot;

	//Ϸ浵
	wchar_t filename[MAX_PATH];
	swprintf_s(filename, L"./data/save/%s.sav", name);
	FILE* fp;
	_wfopen_s(&fp, filename, L"rb");
	if (!fp)
	{
		slot.loadFail = true;
		return slot;
	}
	std::vector<BYTE> cbuff;
	fseek(fp, 0, SEEK_END);
	size_t fileLen = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	cbuff.resize(fileLen);
	fread_s(cbuff.data(), fileLen, fileLen, 1, fp);
	fclose(fp);
	std::vector<BYTE> byte_buff;
	size_t len = 0;
	ZLibUncompressData(&byte_buff, &len, cbuff.data(), fileLen);
	//ȡXML
	const char* xmlStr = (const char*)byte_buff.data();
	tinyxml2::XMLDocument xmlDoc;
	xmlDoc.Parse(xmlStr);
	/*-------------------------------ѰSlotԪ--------------------------------*/
	tinyxml2::XMLElement* elem = nullptr;
	std::vector<wchar_t> wbuff;
	std::vector<int> numArr;
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Slot"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem)
	{
		struct TempMycharData
		{
			std::string elemName;
			SlotMycharData* pData = nullptr;
		};
		TempMycharData mcArr[2];
		mcArr[0].elemName = "SlotPlayer1";
		mcArr[0].pData = &slot.player1;
		mcArr[1].elemName = "SlotPlayer2";
		mcArr[1].pData = &slot.player2;
		//ȡSlotԪ
		for (auto& p : mcArr)
		{
			//ȡԪ
			for (tinyxml2::XMLElement* elem_slot = elem->FirstChildElement(); elem_slot; elem_slot = elem_slot->NextSiblingElement())
			{
				if (elem_slot->Name() != p.elemName)
					continue;
				//ȡֵ
				//Slot_png
				UTF8ToUTF16(elem_slot->Attribute("Slot_png"), &wbuff);
				p.pData->png = wbuff.data();
				//Slot_spriteIndex
				UTF8ToUTF16(elem_slot->Attribute("Slot_spriteIndex"), &wbuff);
				p.pData->spriteIndex = wbuff.data();
				//Slot_imageIndex
				p.pData->imageIndex = elem_slot->IntAttribute("Slot_imageIndex");
				//Slot_hideLayerList
				UTF8ToUTF16(elem_slot->Attribute("Slot_hideLayerList"), &wbuff);
				ParseInts(wbuff.data(), numArr);
				for (auto& i : numArr)
					p.pData->hideLayerList.insert(i);
				//Slot_HpMax
				p.pData->HpMax = elem_slot->IntAttribute("Slot_HpMax");
				//Slot_Hp
				p.pData->Hp = elem_slot->IntAttribute("Slot_Hp");
				//Slot_MpMax
				p.pData->MpMax = elem_slot->IntAttribute("Slot_MpMax");
				//Slot_Mp
				p.pData->Mp = elem_slot->IntAttribute("Slot_Mp");
				//Slot_UIName
				UTF8ToUTF16(elem_slot->Attribute("Slot_UIName"), &wbuff);
				p.pData->uiName = wbuff.data();
				//Slot_Sk1
				p.pData->SkillArr[0] = elem_slot->IntAttribute("Slot_Sk1");
				//Slot_Sk2
				p.pData->SkillArr[1] = elem_slot->IntAttribute("Slot_Sk2");
				//Slot_Sk3
				p.pData->SkillArr[2] = elem_slot->IntAttribute("Slot_Sk3");
				//Slot_Sk4
				p.pData->SkillArr[3] = elem_slot->IntAttribute("Slot_Sk4");
				//Slot_Sk5
				p.pData->SkillArr[4] = elem_slot->IntAttribute("Slot_Sk5");
				//Slot_Sk6
				p.pData->SkillArr[5] = elem_slot->IntAttribute("Slot_Sk6");
				//Slot_ThrowItem
				UTF8ToUTF16(elem_slot->Attribute("Slot_ThrowItem"), &wbuff);
				ParseInts(wbuff.data(), numArr);
				p.pData->throwItem = numArr;
			}
		}
		slot.loadFail = false;
		return slot;
	}
	else
	{
		//ûҵSlotԪأɰ浵
		slot.loadFail = true;
		return slot;
	}
}

