#include "MapDrawer.h"
#include "MyView.h"
#include "GameMap.h"
#include "GamePxa.h"
#include "main.h"
#include "resource.h"
#include <algorithm>
MapDrawer::~MapDrawer()
{
	if (tas.pSRV)
		tas.pSRV->Release();
	if (tas.pTexture)
		tas.pTexture->Release();
}

void MapDrawer::Init(MyDX11Renderer* pRenderer, MyView* pView, GamePxa* gamePxa)
{
	this->pRenderer = pRenderer;
	this->pView = pView;
	this->gamePxa = gamePxa;
}

void MapDrawer::DrawLayerBack(MyMapLayer* pLayer, float windAniIndex, float windAniIndex2)
{
	//
	auto& view = *pView;
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		view.offX -= (1 - farValue) * pView->offX;
		view.offY -= (1 - farValue) * pView->offY;
	}
	//ûƼ
	if (pLayer->enableClipZone)
	{
		MyRect clip;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		pRenderer->SetScissorRect(&clip);
	}
	auto& pxaData = *gamePxa->GetPxa(pLayer->pxaName.c_str());
	float scaleW = pView->scale * 16.0f / pxaData.tileW;
	float scaleH = pView->scale * 16.0f / pxaData.tileH;
	if (pxaData.bInterArea)
		pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
	else
		pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);

	MyRect src, dst;
	MyViewDrawFor vFor;
	vFor.Init(&view);
	vFor.DrawForYBegin();
	for (; vFor.DrawForY(); vFor.DrawForYInc())
	{
		if (vFor._y >= pLayer->pxmArr_h)
			continue;
		vFor.DrawForXBegin();
		for (; vFor.DrawForX(&dst); vFor.DrawForXInc())
		{
			if (vFor._x >= pLayer->pxmArr_w)
				continue;
			auto pxmArr_i = vFor._y * pLayer->pxmArr_w + vFor._x;
			if (pxmArr_i >= pLayer->pxmArr.size())
				continue;
			auto pxmID = pLayer->pxmArr[pxmArr_i];
			//0ŵ
			if (pxmID == 0)
				continue;
			auto pxaID = pxaData.pxaArr[pxmID];
			//Ǳ
			if (!gamePxa->IsBackPxa(pxaID))
				continue;
			float srcX = pxmID % pxaData.pxaArr_w;
			float srcY = pxmID / pxaData.pxaArr_w;
			if (gamePxa->IsWindPxa(pxaID))
			{
				//Ʒ糡
				switch (pxaID)
				{
				case 0x60://
				case 0x70:
					//һ
					src.Set1((srcX + windAniIndex) * pxaData.tileW,
						(srcY + 1) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x61://
				case 0x71:
					src.Set1((srcX + windAniIndex2) * pxaData.tileW,
						(srcY + 1 + windAniIndex2) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x62://
				case 0x72:
					src.Set1(srcX * pxaData.tileW,
						(srcY + 1 + windAniIndex) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x63://
				case 0x73:
					src.Set1((srcX + 1 - windAniIndex2) * pxaData.tileW,
						(srcY + 1 + windAniIndex2) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x64://
				case 0x74:
					src.Set1((srcX + 1 - windAniIndex) * pxaData.tileW,
						(srcY + 1) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x65://
				case 0x75:
					src.Set1((srcX + windAniIndex2) * pxaData.tileW,
						(srcY + 2 - windAniIndex2) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x66://
				case 0x76:
					src.Set1(srcX * pxaData.tileW,
						(srcY + 2 - windAniIndex) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				case 0x67://
				case 0x77:
					src.Set1((srcX + 1 - windAniIndex2) * pxaData.tileW,
						(srcY + 2 - windAniIndex2) * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					break;
				}
			}
			else
			{
				src.Set1(srcX * pxaData.tileW,
					srcY * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
			}
			if (pxaData.bInterArea)
			{
				MyRect srcRedir = src;
				srcRedir.left *= scaleW;
				srcRedir.right *= scaleW;
				srcRedir.top *= scaleH;
				srcRedir.bottom *= scaleH;
				pRenderer->AddRenderCopy(&srcRedir, &dst, pLayer->color);
			}
			else
			{
				pRenderer->AddRenderCopy(&src, &dst, pLayer->color);
			}
		}
	}
	pRenderer->DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
	if (pLayer->enableClipZone)
		pRenderer->SetScissorRect();
}

void MapDrawer::DrawLayerFront(MyMapLayer* pLayer)
{
	//
	auto& view = *pView;
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		view.offX -= (1 - farValue) * pView->offX;
		view.offY -= (1 - farValue) * pView->offY;
	}
	//ûƼ
	if (pLayer->enableClipZone)
	{
		MyRect clip;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		pRenderer->SetScissorRect(&clip);
	}
	auto& pxaData = *gamePxa->GetPxa(pLayer->pxaName.c_str());
	float scaleW = pView->scale * 16.0f / pxaData.tileW;
	float scaleH = pView->scale * 16.0f / pxaData.tileH;
	if (pxaData.bInterArea)
		pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
	else
		pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);

	MyRect src, dst;
	MyViewDrawFor vFor;
	vFor.Init(&view);
	vFor.DrawForYBegin();
	for (; vFor.DrawForY(); vFor.DrawForYInc())
	{
		if (vFor._y >= pLayer->pxmArr_h)
			continue;
		vFor.DrawForXBegin();
		for (; vFor.DrawForX(&dst); vFor.DrawForXInc())
		{
			if (vFor._x >= pLayer->pxmArr_w)
				continue;
			auto pxmArr_i = vFor._y * pLayer->pxmArr_w + vFor._x;
			if (pxmArr_i >= pLayer->pxmArr.size())
				continue;
			auto pxmID = pLayer->pxmArr[pxmArr_i];
			//0ŵ
			if (pxmID == 0)
				continue;
			auto pxaID = pxaData.pxaArr[pxmID];
			//Ǳ
			if (gamePxa->IsBackPxa(pxaID))
				continue;
			float srcX = pxmID % pxaData.pxaArr_w;
			float srcY = pxmID / pxaData.pxaArr_w;
			src.Set1(srcX * pxaData.tileW,
				srcY * pxaData.tileH,
				(float)pxaData.tileW,
				(float)pxaData.tileH);
			if (pxaData.bInterArea)
			{
				MyRect srcRedir = src;
				srcRedir.left *= scaleW;
				srcRedir.right *= scaleW;
				srcRedir.top *= scaleH;
				srcRedir.bottom *= scaleH;
				pRenderer->AddRenderCopy(&srcRedir, &dst, pLayer->color);
			}
			else
			{
				pRenderer->AddRenderCopy(&src, &dst, pLayer->color);
			}
		}
	}
	pRenderer->DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
	if (pLayer->enableClipZone)
		pRenderer->SetScissorRect();
}

void MapDrawer::DrawLoopLayer(MyMapLayer* pLayer, float delteTime)
{
	auto& view = *pView;
	auto& step = pLayer->step_pxm;
	auto& pxaData = *gamePxa->GetPxa(pLayer->pxaName.c_str());
	float scaleW = pView->scale * 16.0f / pxaData.tileW;
	float scaleH = pView->scale * 16.0f / pxaData.tileH;
	MyRect clip;
	if (pLayer->enableClipZone)
	{
		MyView srcView = view;
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX -= (1 - farValue) * view.offX;
		view.offY -= (1 - farValue) * view.offY;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		view = srcView;
	}
	else
	{
		clip.Set1(-view.offX * view.scale,
			-view.offY * view.scale,
			view.grid_w * view.count_w * view.scale + 1,
			view.grid_h * (view.count_max / view.count_w) * view.scale + 1);
	}
	//üо
	//ѭ
	int minXIndex = INT_MAX;
	int minYIndex = INT_MAX;
	int maxXIndex = INT_MIN;
	int maxYIndex = INT_MIN;
	//ȡƬΧ
	for (auto& t : step)
	{
		int srcX = (int)LOWORD(t.first);
		int srcY = (int)HIWORD(t.first);
		if (srcX < minXIndex)
			minXIndex = srcX;
		if (srcY < minYIndex)
			minYIndex = srcY;
		if (srcX > maxXIndex)
			maxXIndex = srcX;
		if (srcY > maxYIndex)
			maxYIndex = srcY;
	}
	if (minXIndex == INT_MAX ||
		minYIndex == INT_MAX ||
		maxXIndex == INT_MIN ||
		maxYIndex == INT_MIN)
		return;//һ
	//ڲŵ
	pRenderer->SetScissorRect(&clip);
	if (pLayer->loopH && pLayer->loopV)
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		MyView srcView = view;
		view.offX -= lerp(pLayer->loopBk_last_x, pLayer->loopBk_x, delteTime);
		view.offY -= lerp(pLayer->loopBk_last_y, pLayer->loopBk_y, delteTime);
		//ϾͷԶƶ
		view.offX -= (1 - farValue) * srcView.offX;
		view.offY -= (1 - farValue) * srcView.offY;
		if (pxaData.bInterArea)
			pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
		else
			pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);

		MyRect rc;
		MyViewDrawFor vFor;
		vFor.Init(&view);
		vFor.DrawForYBegin();
		vFor._y -= th;
		vFor.rc_draw_y -= vFor.rc_draw_h * th;
		for (; vFor.DrawForY(); vFor.DrawForYInc())
		{
			vFor.DrawForXBegin();
			vFor._x -= tw;
			vFor.rc_draw_x -= vFor.rc_draw_w * tw;
			for (; vFor.DrawForX(&rc); vFor.DrawForXInc())
			{
				int& x = vFor._x;
				int& y = vFor._y;
				if (y * view.count_w + x >= view.count_max)
					goto CMapEditorDraw_DrawLoopLayer_DrawHV_End;
				int dxSrc = (x - minXIndex) % tw;
				int dySrc = (y - minYIndex) % th;
				if (dxSrc < 0)
					dxSrc = tw - abs(dxSrc) % tw;
				if (dySrc < 0)
					dySrc = th - abs(dySrc) % th;
				int XIndexSrc = dxSrc + minXIndex;
				int YIndexSrc = dySrc + minYIndex;
				auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
				if (iter == step.end())
					continue;
				float srcX = (float)LOWORD(iter->second);
				float srcY = (float)HIWORD(iter->second);
				MyRect src;
				src.Set1(srcX * pxaData.tileW,
					srcY * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				if (pxaData.bInterArea)
				{
					MyRect srcRedir = src;
					srcRedir.left *= scaleW;
					srcRedir.right *= scaleW;
					srcRedir.top *= scaleH;
					srcRedir.bottom *= scaleH;
					pRenderer->AddRenderCopy(&srcRedir, &rc, pLayer->color);
				}
				else
				{
					pRenderer->AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		}
	CMapEditorDraw_DrawLoopLayer_DrawHV_End:
		pRenderer->DrawRenderCopy();
		view = srcView;
	}
	else if (pLayer->loopH)//ֻˮƽѭ
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		MyView srcView = view;
		view.offX -= lerp(pLayer->loopBk_last_x, pLayer->loopBk_x, delteTime);
		view.offY -= lerp(pLayer->loopBk_last_y, pLayer->loopBk_y, delteTime);
		//ϾͷԶƶ
		view.offX -= (1 - farValue) * srcView.offX;
		view.offY -= (1 - farValue) * srcView.offY;
		//
		if (pLayer->loopNeg)
		{
			//ƫ
			if ((srcView.count_max / srcView.count_w) * srcView.grid_h * srcView.scale < srcView.window_h)
				view.offY += (srcView.window_h - (srcView.count_max / srcView.count_w) * srcView.grid_h * srcView.scale) / 2 / srcView.scale;
			view.offY -= srcView.window_h / srcView.scale - (srcView.count_max / srcView.count_w * srcView.grid_h);
		}
		else
		{
			//ƫ
			if ((srcView.count_max / srcView.count_w) * srcView.grid_h * srcView.scale < srcView.window_h)
				view.offY -= (srcView.window_h - (srcView.count_max / srcView.count_w) * srcView.grid_h * srcView.scale) / 2 / srcView.scale;
		}
		if (pxaData.bInterArea)
			pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
		else
			pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);

		MyRect rc;
		MyViewDrawFor vFor;
		vFor.Init(&view);
		vFor.DrawForYBegin();
		vFor._y = minYIndex;
		vFor.rc_draw_y = (vFor._y * view.grid_h) * view.scale - floorf(view.offY * view.scale);
		for (; vFor._y <= maxYIndex; vFor.DrawForYInc())
		{
			vFor.DrawForXBegin();
			vFor._x -= tw;
			vFor.rc_draw_x -= vFor.rc_draw_w * tw;
			for (; vFor.DrawForX(&rc); vFor.DrawForXInc())
			{
				int& x = vFor._x;
				int& y = vFor._y;
				if (y * view.count_w + x >= view.count_max)
					goto CMapEditorDraw_DrawLoopLayer_DrawH_End;
				int dxSrc = (x - minXIndex) % tw;
				int dySrc = (y - minYIndex) % th;
				if (dxSrc < 0)
					dxSrc = tw - abs(dxSrc) % tw;
				if (dySrc < 0)
					dySrc = th - abs(dySrc) % th;
				int XIndexSrc = dxSrc + minXIndex;
				int YIndexSrc = dySrc + minYIndex;
				auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
				if (iter == step.end())
					continue;
				float srcX = (float)LOWORD(iter->second);
				float srcY = (float)HIWORD(iter->second);
				MyRect src;
				src.Set1(srcX * pxaData.tileW,
					srcY * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				if (pxaData.bInterArea)
				{
					MyRect srcRedir = src;
					srcRedir.left *= scaleW;
					srcRedir.right *= scaleW;
					srcRedir.top *= scaleH;
					srcRedir.bottom *= scaleH;
					pRenderer->AddRenderCopy(&srcRedir, &rc, pLayer->color);
				}
				else
				{
					pRenderer->AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		}
	CMapEditorDraw_DrawLoopLayer_DrawH_End:
		pRenderer->DrawRenderCopy();
		view = srcView;
	}
	else if (pLayer->loopV)//ֱֻѭ
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		MyView srcView = view;
		view.offX -= lerp(pLayer->loopBk_last_x, pLayer->loopBk_x, delteTime);
		view.offY -= lerp(pLayer->loopBk_last_y, pLayer->loopBk_y, delteTime);
		//ϾͷԶƶ
		view.offX -= (1 - farValue) * srcView.offX;
		view.offY -= (1 - farValue) * srcView.offY;
		//Ҷ
		if (pLayer->loopNeg)
		{
			//ƫ
			if (srcView.count_w * srcView.grid_w * srcView.scale < srcView.window_w)
				view.offX += (srcView.window_w - srcView.count_w * srcView.grid_w * srcView.scale) / 2 / srcView.scale;
			view.offX -= srcView.window_w / srcView.scale - (srcView.count_w * srcView.grid_w);
		}
		else
		{
			//ƫ
			if (srcView.count_w * srcView.grid_w * srcView.scale < srcView.window_w)
				view.offX -= (srcView.window_w - srcView.count_w * srcView.grid_w * srcView.scale) / 2 / srcView.scale;
		}
		if (pxaData.bInterArea)
			pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
		else
			pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);

		MyRect rc;
		MyViewDrawFor vFor;
		vFor.Init(&view);
		vFor.DrawForYBegin();
		vFor._y -= th;
		vFor.rc_draw_y -= vFor.rc_draw_h * th;
		for (; vFor.DrawForY(); vFor.DrawForYInc())
		{
			vFor.DrawForXBegin();
			vFor._x = minXIndex;
			vFor.rc_draw_x = (vFor._x * view.grid_w) * view.scale - floorf(view.offX * view.scale);
			for (; vFor._x <= maxXIndex; vFor.DrawForXInc())
			{
				rc.Set1(vFor.rc_draw_x, vFor.rc_draw_y, vFor.rc_draw_w, vFor.rc_draw_h);
				int& x = vFor._x;
				int& y = vFor._y;
				if (y * view.count_w + x >= view.count_max)
					goto CMapEditorDraw_DrawLoopLayer_DrawV_End;
				int dxSrc = (x - minXIndex) % tw;
				int dySrc = (y - minYIndex) % th;
				if (dxSrc < 0)
					dxSrc = tw - abs(dxSrc) % tw;
				if (dySrc < 0)
					dySrc = th - abs(dySrc) % th;
				int XIndexSrc = dxSrc + minXIndex;
				int YIndexSrc = dySrc + minYIndex;
				auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
				if (iter == step.end())
					continue;
				float srcX = (float)LOWORD(iter->second);
				float srcY = (float)HIWORD(iter->second);
				MyRect src;
				src.Set1(srcX * pxaData.tileW,
					srcY * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				if (pxaData.bInterArea)
				{
					MyRect srcRedir = src;
					srcRedir.left *= scaleW;
					srcRedir.right *= scaleW;
					srcRedir.top *= scaleH;
					srcRedir.bottom *= scaleH;
					pRenderer->AddRenderCopy(&srcRedir, &rc, pLayer->color);
				}
				else
				{
					pRenderer->AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		}
	CMapEditorDraw_DrawLoopLayer_DrawV_End:
		pRenderer->DrawRenderCopy();
		view = srcView;
	}
	else
	{
		//ѭ
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		MyView srcView = view;
		view.offX -= lerp(pLayer->loopBk_last_x, pLayer->loopBk_x, delteTime);
		view.offY -= lerp(pLayer->loopBk_last_y, pLayer->loopBk_y, delteTime);
		//ϾͷԶƶ
		view.offX -= (1 - farValue) * srcView.offX;
		view.offY -= (1 - farValue) * srcView.offY;
		if (pxaData.bInterArea)
			pRenderer->SetTPenDraw(GetPxaTextureInterArea(pLayer->pxaName.c_str(), scaleW, scaleH)->pSRV);
		else
			pRenderer->SetTPenDraw(GetPxaTexture(pLayer->pxaName.c_str())->pSRV);
		for (auto& t : step)
		{
			float srcX = (float)LOWORD(t.second);
			float srcY = (float)HIWORD(t.second);
			float dstX = (float)LOWORD(t.first);
			float dstY = (float)HIWORD(t.first);
			MyRect src, dst;
			src.Set1(srcX * pxaData.tileW,
				srcY * pxaData.tileH,
				(float)pxaData.tileW,
				(float)pxaData.tileH);
			dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
				((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
				view.grid_w * view.scale,
				view.grid_h * view.scale);
			//ԻǷĻ
			if (pxaData.bInterArea)
			{
				MyRect srcRedir = src;
				srcRedir.left *= scaleW;
				srcRedir.right *= scaleW;
				srcRedir.top *= scaleH;
				srcRedir.bottom *= scaleH;
				pRenderer->AddRenderCopy(&srcRedir, &dst, pLayer->color);
			}
			else
			{
				pRenderer->AddRenderCopy(&src, &dst, pLayer->color);
			}
		}
		pRenderer->DrawRenderCopy();
		view = srcView;
	}
	pRenderer->SetScissorRect();
}

void MapDrawer::DrawPxaLayer(MyMapLayer* pLayer)
{
	auto& view = *pView;
	auto& pxaData = *gamePxa->GetPxa(pLayer->pxaName.c_str());
	auto& tas = *GetResTexture(IDR_PXATYPE);

	pRenderer->SetTPenDraw(tas.pSRV);
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		view.offX -= (1 - farValue) * pView->offX;
		view.offY -= (1 - farValue) * pView->offY;
	}
	MyRect src, dst;
	MyViewDrawFor vFor;
	vFor.Init(&view);
	vFor.DrawForYBegin();
	for (; vFor.DrawForY(); vFor.DrawForYInc())
	{
		if (vFor._y >= pLayer->pxmArr_h)
			continue;
		vFor.DrawForXBegin();
		for (; vFor.DrawForX(&dst); vFor.DrawForXInc())
		{
			if (vFor._x >= pLayer->pxmArr_w)
				continue;
			auto pxmArr_i = vFor._y * pLayer->pxmArr_w + vFor._x;
			if (pxmArr_i >= pLayer->pxmArr.size())
				continue;
			auto pxmID = pLayer->pxmArr[pxmArr_i];
			//0ŵ
			if (pxmID == 0)
				continue;
			auto pxaID = pxaData.pxaArr[pxmID];
			float srcX = (float)(pxaID % 16);
			float srcY = (float)(pxaID / 16);
			src.Set1(srcX * pxaData.tileW,
				srcY * pxaData.tileH,
				(float)pxaData.tileW,
				(float)pxaData.tileH);
			pRenderer->AddRenderCopy(&src, &dst, RGBA(0xff, 0xff, 0xff, 0x80));
		}
	}
	pRenderer->DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
}

void MapDrawer::DrawRoomName(const wchar_t* roomName)
{
	if (roomName_fadein)
	{
		if (roomName_alpha < 255)
		{
			roomName_alpha += roomName_fadespeed;
			if (roomName_alpha > 255)
				roomName_alpha = 255;
		}
		else
		{
			roomName_fadein = false;
			roomName_fadeWait = true;
			roomName_counter = 0;
		}
	}
	if (roomName_fadeWait)
	{
		if (roomName_counter < roomName_counter_max)
			roomName_counter++;
		else
		{
			roomName_fadeWait = false;
			roomName_fadeout = true;
		}
	}
	if (roomName_fadeout)
	{
		if (roomName_alpha > 0)
		{
			roomName_alpha -= roomName_fadespeed;
			if (roomName_alpha < 0)
				roomName_alpha = 0;
		}
		else
			roomName_fadeout = false;
	}
	if (roomName_alpha != 0)
	{
		if (this->roomName != roomName)
		{
			this->roomName = roomName;
			OnResetScale();
		}
		if (this->roomName.length() && tas.pSRV)
		{
			MyView& view = *pView;
			MyRect dst;
			dst.Set1((view.window_w - tas.w) / 2,
				(view.window_h - tas.h) / 4,
				(float)tas.w,
				(float)tas.h);
			pRenderer->SetTPenDraw(tas.pSRV);
			pRenderer->AddRenderCopy(nullptr, &dst, RGBA(0xff, 0xff, 0xff, roomName_alpha));
			pRenderer->DrawRenderCopy();
		}
	}
}

void MapDrawer::OnResetScale()
{
	if (!roomName.length())
		return;
	if (tas.pSRV)
		tas.pSRV->Release();
	if (tas.pTexture)
		tas.pTexture->Release();
	MyView& view = *pView;
	SDL_Color c;
	c.r = c.g = c.b = c.a = 0xff;
	auto font = pRenderer->MyLoadFont(highQualityFont.c_str(), (int)(12 * view.scale));
	auto s = TTF_RenderUNICODE_Blended(font, (const Uint16*)roomName.c_str(), c);
	TTF_CloseFont(font);
	tas.w = s->w;
	tas.h = s->h;
	pRenderer->MyCreateTextureFromSDLSurface(&tas.pTexture, s);
	pRenderer->MyCreateShaderResourceView(&tas.pSRV, tas.pTexture);
	SDL_FreeSurface(s);
}

void MapDrawer::MNA()
{
	roomName_fadein = true;
}

void MapDrawer::Reset()
{
	roomName_alpha = 0;
	roomName_counter = 0;
	roomName_fadein = false;
	roomName_fadeWait = false;
	roomName_fadeout = false;
}

void MapDrawer::LoopLayerStep(MyMapLayer* pLayer, float timeCounter)
{
	auto& view = *pView;
	auto& step = pLayer->step_pxm;
	//üо
	//ѭ
	int minXIndex = INT_MAX;
	int minYIndex = INT_MAX;
	int maxXIndex = INT_MIN;
	int maxYIndex = INT_MIN;
	//ȡƬΧ
	for (auto& t : step)
	{
		int srcX = (int)LOWORD(t.first);
		int srcY = (int)HIWORD(t.first);
		if (srcX < minXIndex)
			minXIndex = srcX;
		if (srcY < minYIndex)
			minYIndex = srcY;
		if (srcX > maxXIndex)
			maxXIndex = srcX;
		if (srcY > maxYIndex)
			maxYIndex = srcY;
	}
	if (minXIndex == INT_MAX ||
		minYIndex == INT_MAX ||
		maxXIndex == INT_MIN ||
		maxYIndex == INT_MIN)
		return;//һ
	pLayer->loopBk_dx = abs(pLayer->loopBk_x - pLayer->loopBk_last_x);
	pLayer->loopBk_dy = abs(pLayer->loopBk_y - pLayer->loopBk_last_y);
	pLayer->loopBk_last_x = pLayer->loopBk_x;
	pLayer->loopBk_last_y = pLayer->loopBk_y;
	if (pLayer->loopH && pLayer->loopV)
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float bk_w = tw * view.grid_w;
		float bk_h = th * view.grid_h;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		float srcLoopOffx = pLayer->speedH * timeCounter * farValue;
		float srcLoopOffy = pLayer->speedV * timeCounter * farValue;
		float res_x = srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
		if (pLayer->speedH > 0)
		{
			if (res_x < pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x - pLayer->loopBk_dx;
		}
		else if (pLayer->speedH < 0)
		{
			if (res_x > pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x + pLayer->loopBk_dx;
		}
		float res_y = srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
		if (pLayer->speedV > 0)
		{
			if (res_y < pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y - pLayer->loopBk_dy;
		}
		else if (pLayer->speedV < 0)
		{
			if (res_y > pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y + pLayer->loopBk_dy;
		}
		pLayer->loopBk_x = res_x;
		pLayer->loopBk_y = res_y;
	}
	else if (pLayer->loopH)//ֻˮƽѭ
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float bk_w = tw * view.grid_w;
		float bk_h = th * view.grid_h;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		float srcLoopOffx = pLayer->speedH * timeCounter * farValue;
		float srcLoopOffy = pLayer->speedV * timeCounter * farValue;
		float res_x = srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
		if (pLayer->speedH > 0)
		{
			if (res_x < pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x - pLayer->loopBk_dx;
		}
		else if (pLayer->speedH < 0)
		{
			if (res_x > pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x + pLayer->loopBk_dx;
		}
		float res_y = srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
		if (pLayer->speedV > 0)
		{
			if (res_y < pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y - pLayer->loopBk_dy;
		}
		else if (pLayer->speedV < 0)
		{
			if (res_y > pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y + pLayer->loopBk_dy;
		}
		pLayer->loopBk_x = res_x;
		pLayer->loopBk_y = res_y;
	}
	else if (pLayer->loopV)//ֱֻѭ
	{
		//ѭƬ
		int tw = maxXIndex + 1 - minXIndex;
		int th = maxYIndex + 1 - minYIndex;
		float bk_w = tw * view.grid_w;
		float bk_h = th * view.grid_h;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		float srcLoopOffx = pLayer->speedH * timeCounter * farValue;
		float srcLoopOffy = pLayer->speedV * timeCounter * farValue;
		float res_x = srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
		if (pLayer->speedH > 0)
		{
			if (res_x < pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x - pLayer->loopBk_dx;
		}
		else if (pLayer->speedH < 0)
		{
			if (res_x > pLayer->loopBk_last_x)
				pLayer->loopBk_last_x = res_x + pLayer->loopBk_dx;
		}
		float res_y = srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
		if (pLayer->speedV > 0)
		{
			if (res_y < pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y - pLayer->loopBk_dy;
		}
		else if (pLayer->speedV < 0)
		{
			if (res_y > pLayer->loopBk_last_y)
				pLayer->loopBk_last_y = res_y + pLayer->loopBk_dy;
		}
		pLayer->loopBk_x = res_x;
		pLayer->loopBk_y = res_y;
	}
	else
	{
		//ѭ
		pLayer->loopBk_x = 0;
		pLayer->loopBk_y = 0;
	}
}

float MapDrawer::MyFar(float myFar)
{
	float k = 16.0f;
	if (myFar <= -k)
		myFar = -k + 0.1f;
	float t = (myFar / k + 1.0f) / (2.0f * tanf(0.5f));
	return 2 * atanf(1.0f / (2.0f * t));
}
