#pragma once
#include "global.h"
#include "MyStructDef.h"

extern PathCell zeroCell;

//Ѱ·ϵͳ
class PathfindingE
{
public:
    PathfindingE();
    void Init(int mapW, int mapH, void* mapLayer, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, int pxmArr_w, size_t cacheSize = 10 * 1024 * 1024);
    void Reset();//ãͼ޸ģ
    void Step();//ʵʱû
    PathGrid* GetPath(WORD dstX, WORD dstY);//ȡ·
    bool LineBlock(float srcX, float srcY, float dstX, float dstY, bool(PathfindingE::* CellProc)(int X, int Y, XMVECTOR* v));//Ƿм䱻赲
    bool CellProc(int X, int Y, XMVECTOR* v);
    void UpdateMapData();
private:
    int mapW = 0;
    int mapH = 0;
    float maxLen = 0;
    void* mapLayer = nullptr;
    std::vector<LONG>* pxmArr = nullptr;
    std::vector<int>* pxaArr = nullptr;
    int pxmArr_w = 0;
    std::vector<BYTE> mapData;
    size_t cacheSize = 100 * 1024 * 1024;//С
    std::unordered_map<LONG, PathGrid> gridTable;
    static bool IsPathBlock(BYTE pxa);
    static bool IsUpBlock(BYTE pxa);
    static bool IsDownBlock(BYTE pxa);
    static bool IsLeftBlock(BYTE pxa);
    static bool IsRightBlock(BYTE pxa);
    static bool IsLine1ZoneBlock(BYTE pxa);
    static bool IsLine2ZoneBlock(BYTE pxa);
    static bool IsLine3ZoneBlock(BYTE pxa);
    static bool IsLine4ZoneBlock(BYTE pxa);
    void MakePath(PathGrid* grid, WORD dstX, WORD dstY);//·
    void StepGrid(PathGrid* grid, int X, int Y);
    void StepVector(PathGrid* grid, int X, int Y);
};

