#include "MyUtil.h"
#include <vector>
#include <string>
#include <sstream>
CString GetFileNameWithoutExtension(const CString& filePath)
{
	// һ·ָ'\'  '/'
	int lastSlash = filePath.ReverseFind('\\');
	int lastFslash = filePath.ReverseFind('/');
	int lastSeparator = max(lastSlash, lastFslash);

	// һţļչָ
	int lastDot = filePath.ReverseFind('.');

	// ȷļֵʼλ
	int fileNameStart = (lastSeparator >= 0) ? lastSeparator + 1 : 0;

	// ȷļֵĽλ
	int fileNameEnd = (lastDot > fileNameStart) ? lastDot : filePath.GetLength();

	// ȡļ
	return filePath.Mid(fileNameStart, fileNameEnd - fileNameStart);
}

CString GetFileDirectory(const CString& fullPath)
{
	// һ·ָ֧ '\'  '/'
	int lastBackslash = fullPath.ReverseFind('\\');
	int lastForwardslash = fullPath.ReverseFind('/');
	int lastSeparator = max(lastBackslash, lastForwardslash);

	// ҵ·ָطָ֮ǰĲ֣·
	if (lastSeparator >= 0)
	{
		return fullPath.Left(lastSeparator);
	}

	// ûҵ·ָؿַʾǰĿ¼
	return _T("");
}

CString ChangeFileExtension(const CString& fullPath, const CString& newExtension)
{
	int lastSlash = fullPath.ReverseFind('\\');
	int lastFslash = fullPath.ReverseFind('/');
	int lastSeparator = max(lastSlash, lastFslash);
	int lastDot = fullPath.ReverseFind('.');

	// ȷ newExtension  '.' ͷ
	CString ext = newExtension;
	if (ext.GetLength() > 0 && ext[0] != '.')
	{
		ext = _T(".") + ext;
	}

	if (lastDot > lastSeparator)
	{
		return fullPath.Left(lastDot) + ext;
	}
	else
	{
		return fullPath + ext;
	}
}

CString ReplaceFileNameKeepPathAndExtension(const CString& originalFullPath, const CString& newFileName)
{
	// 1. һ·ָ'\'  '/'
	int lastBackslash = originalFullPath.ReverseFind('\\');
	int lastForwardslash = originalFullPath.ReverseFind('/');
	int lastSeparator = max(lastBackslash, lastForwardslash);

	// 2. һţļչָ
	int lastDot = originalFullPath.ReverseFind('.');

	// 3. ȡԭ·չ
	CString originalPath = (lastSeparator >= 0) ? originalFullPath.Left(lastSeparator + 1).GetString() : L"";
	CString originalExtension = (lastDot > lastSeparator) ? originalFullPath.Mid(lastDot).GetString() : L"";

	// 4. ļ· + ļ + ԭչ
	return originalPath + newFileName + originalExtension;
}

CString TruncateFilePath(const CString& fullPath, const CString& basePath)
{
	// 1. ͳһ·ָΪбܣȷȽһԣ
	CString normalizedFull = fullPath;
	normalizedFull.Replace(_T("/"), _T("\\"));

	CString normalizedBase = basePath;
	normalizedBase.Replace(_T("/"), _T("\\"));

	// 2. ȷbasePathԷбܽβڱȽϣ
	if (!normalizedBase.IsEmpty() && normalizedBase.GetAt(normalizedBase.GetLength() - 1) != _T('\\')) {
		normalizedBase += _T("\\");
	}

	// 3. basePathfullPathеλ
	int pos = normalizedFull.Find(normalizedBase);
	if (pos == 0) { // ƥ䵽ͷ
		CString relativePart = normalizedFull.Mid(normalizedBase.GetLength());

		// 4. ȥļչ
		int dotPos = relativePart.ReverseFind(_T('.'));
		if (dotPos > 0) {
			relativePart = relativePart.Left(dotPos);
		}

		// 5. ȥͷķбܣڣ
		if (!relativePart.IsEmpty() && relativePart.GetAt(0) == _T('\\')) {
			relativePart = relativePart.Mid(1);
		}

		return relativePart;
	}

	// ƥ䣬ԭʼ·ȥչ
	int dotPos = normalizedFull.ReverseFind(_T('.'));
	if (dotPos > 0) {
		return normalizedFull.Left(dotPos).Mid(normalizedFull.ReverseFind(_T('\\')) + 1);
	}
	return normalizedFull.Mid(normalizedFull.ReverseFind(_T('\\')) + 1);
}

CString GetRelativePathWithPrefix(const CString& fullPath, const CString& basePath)
{
	// 1. ͳһ·ָΪб
	CString normalizedFull = fullPath;
	normalizedFull.Replace(_T("/"), _T("\\"));

	CString normalizedBase = basePath;
	normalizedBase.Replace(_T("/"), _T("\\"));

	// 2. ȷbasePathԷбܽβ
	if (!normalizedBase.IsEmpty() && normalizedBase.GetAt(normalizedBase.GetLength() - 1) != _T('\\')) {
		normalizedBase += _T("\\");
	}

	// 3. basePathfullPathеλ
	int pos = normalizedFull.Find(normalizedBase);
	if (pos == 0) { // ƥ䵽ͷ
		CString relativePart = normalizedFull.Mid(normalizedBase.GetLength());

		// 4. ".\"ǰ׺
		if (!relativePart.IsEmpty()) {
			// ԭе·ǰ׺".\""..\"
			if (relativePart.Find(_T(".\\")) == 0 || relativePart.Find(_T("..\\")) == 0) {
				// Ѿǰ׺
			}
			else {
				relativePart = _T(".\\") + relativePart;
			}
		}

		return relativePart;
	}

	// 5. ƥ䣬ش".\"ǰ׺ļ
	int lastBackslash = normalizedFull.ReverseFind(_T('\\'));
	if (lastBackslash >= 0) {
		return _T(".\\") + normalizedFull.Mid(lastBackslash + 1);
	}
	return _T(".\\") + normalizedFull;
}

std::wstring JoinWithSemicolon(const std::vector<std::wstring>& vec)
{
	std::wstringstream ss;
	for (size_t i = 0; i < vec.size(); ++i) 
	{
		if (i != 0) {
			ss << L";";
		}
		ss << vec[i];
	}
	return ss.str();
}

std::vector<std::wstring> SplitBySemicolon(const std::wstring& str)
{
	std::vector<std::wstring> result;
	std::wstringstream ss(str);
	std::wstring item;
	while (std::getline(ss, item, L';')) 
	{
		if (!item.empty()) 
			result.push_back(item);
	}
	return result;
}
