#include "EntityDll.h"
#include <process.h>

void EntityDll::Load(const wchar_t* dllName)
{
	wchar_t wbuff[MAX_PATH];
	swprintf_s(wbuff, L"./data/entity/%s.dll", dllName);
	if (dll)
		FreeLibrary(dll);
	dll = LoadLibraryW(wbuff);
	if (!dll)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"%sʧ", wbuff);
		MessageBoxW(AfxGetApp()->GetMainWnd()->m_hWnd, err, L"dllļʧ", MB_ICONWARNING);
		exit(0);
	}
	_GameCreateEntity = (void (*)(const wchar_t*, std::shared_ptr<Entity>*))GetProcAddress(dll, "GameCreateEntity");
	if (!_GameCreateEntity)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"%sʧ", wbuff);
		MessageBoxW(AfxGetApp()->GetMainWnd()->m_hWnd, L"GameCreateEntityʧ", err, MB_ICONWARNING);
		exit(0);
	}
	_GetEntityCount = (int (*)())GetProcAddress(dll, "GetEntityCount");
	if (!_GetEntityCount)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"%sʧ", wbuff);
		MessageBoxW(AfxGetApp()->GetMainWnd()->m_hWnd, L"GetEntityCountʧ", err, MB_ICONWARNING);
		exit(0);
	}
	_GetEntityName = (const wchar_t* (*)(int))GetProcAddress(dll, "GetEntityName");
	if (!_GetEntityName)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"%sʧ", wbuff);
		MessageBoxW(AfxGetApp()->GetMainWnd()->m_hWnd, L"GetEntityNameʧ", err, MB_ICONWARNING);
		exit(0);
	}
}
