#include "CPxaEditorGrid.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CPxaEditorGrid, CDialog)

BEGIN_MESSAGE_MAP(CPxaEditorGrid, CDialog)
	ON_BN_CLICKED(IDOK, &CPxaEditorGrid::OnBnClickedOk)
END_MESSAGE_MAP()

CPxaEditorGrid::CPxaEditorGrid(CWnd* pParent)
	: CDialog(IDD_CPXAEDITOR_GRID, pParent)
{
}

CPxaEditorGrid::~CPxaEditorGrid()
{
}

void CPxaEditorGrid::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_GRID_W, edit_grid_w);
	DDX_Control(pDX, IDC_EDIT_GRID_H, edit_grid_h);
	DDX_Control(pDX, IDC_CHECK_INTERAREA, check_interArea);
}

BOOL CPxaEditorGrid::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetDlgItemInt(IDC_EDIT_GRID_W, outGridW);
	SetDlgItemInt(IDC_EDIT_GRID_H, outGridH);
	check_interArea.SetCheck(outInterArea ? 1 : 0);
	return 0;
}

void CPxaEditorGrid::OnBnClickedOk()
{
	int grid_w = GetDlgItemInt(IDC_EDIT_GRID_W);
	if (grid_w < 1)
	{
		MessageBox(L"ԪߴȲС1", L"дЧ");
		return;
	}

	int grid_h = GetDlgItemInt(IDC_EDIT_GRID_H);
	if (grid_h < 1)
	{
		MessageBox(L"Ԫߴ߶ȲС1", L"дЧ");
		return;
	}
	outGridW = grid_w;
	outGridH = grid_h;
	outInterArea = check_interArea.GetCheck();
	CDialog::OnOK();
}
