#include "CPxaEditorBrush.h"
#include "resource.h"
#include "CPxaEditor.h"

IMPLEMENT_DYNAMIC(CPxaEditorBrush, CDialog)

BEGIN_MESSAGE_MAP(CPxaEditorBrush, CDialog)
	ON_COMMAND(IDOK, &CPxaEditorBrush::OnEnterKey)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSEMOVE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

CPxaEditorBrush::CPxaEditorBrush(CWnd* pParent)
	: CDialog(IDD_CPXAEDITOR_BRUSH, pParent)
{
}

CPxaEditorBrush::~CPxaEditorBrush()
{
	if (tas.pSRV)
		tas.pSRV->Release();
	if (tas.pTexture)
		tas.pTexture->Release();
}

MyView* CPxaEditorBrush::GetMyView()
{
	return &view;
}

void CPxaEditorBrush::Draw()
{
	pRenderer.RenderClear();
	if (tas.pSRV)
	{
		MyRect src, dst;
		pRenderer.GetRenderCopyDefaultRect(tas.pSRV, &src, nullptr);
		dst.Set1(-floorf(view.offX * view.scale),
			-floorf(view.offY * view.scale),
			src.GetWidth() * view.scale,
			src.GetHeight() * view.scale);
		pRenderer.SetTPenDraw(tas.pSRV);
		pRenderer.AddRenderCopy(nullptr, &dst);
		pRenderer.DrawRenderCopy();
	}
	view.DrawBorderLine();//Ʊ߽
	view.DrawCursor();//ƹ
	pRenderer.RenderPresent();
}

BOOL CPxaEditorBrush::PreTranslateMessage(MSG* pMsg)
{
	auto parentEditor = (CPxaEditor*)pParentEditor;
	if (TranslateAccelerator(parentEditor->GetSafeHwnd(), parentEditor->hAccel, pMsg))
		return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}

void CPxaEditorBrush::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CPxaEditorBrush::OnInitDialog()
{
	CDialog::OnInitDialog();
	pRenderer.Init(m_hWnd);
	view.Init(this, &pRenderer);
	//Դ
	LoadResourceTexture(&pRenderer, IDR_PXATYPE, &tas.pTexture, &tas.pSRV);
	//
	UpdateGrid();
	view.SetScrollBar();
	return 0;
}

void CPxaEditorBrush::OnCancel()
{
	ShowWindow(SW_HIDE);
}

void CPxaEditorBrush::OnEnterKey()
{
}

void CPxaEditorBrush::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	if (!view.pRenderer)
		return;
	view.window_w = (float)cx;
	view.window_h = (float)cy;
	pRenderer.OnSize(cx, cy, nType == SIZE_MINIMIZED);
}

void CPxaEditorBrush::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);
	auto parentEditor = (CPxaEditor*)pParentEditor;

	if (bShow)
		parentEditor->GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_BRUSH_WND, MF_BYCOMMAND | MF_CHECKED);
	else
		parentEditor->GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_BRUSH_WND, MF_BYCOMMAND | MF_UNCHECKED);
}

void CPxaEditorBrush::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// ΪͼϢ CDialog::OnPaint()
	Draw();
}

void CPxaEditorBrush::OnLButtonDown(UINT nFlags, CPoint point)
{
	view.BeginSelect(point);
	Draw();
	CDialog::OnLButtonDown(nFlags, point);
}

void CPxaEditorBrush::OnLButtonUp(UINT nFlags, CPoint point)
{
	CDialog::OnLButtonUp(nFlags, point);
	view.EndSelect();
}

void CPxaEditorBrush::OnRButtonDown(UINT nFlags, CPoint point)
{
	view.WindowBind_OnRButtonDown(point);
	CDialog::OnRButtonDown(nFlags, point);
}

void CPxaEditorBrush::OnRButtonUp(UINT nFlags, CPoint point)
{
	view.WindowBind_OnRButtonUp();
	CDialog::OnRButtonUp(nFlags, point);
}

BOOL CPxaEditorBrush::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	if (view.WindowBind_OnMouseWheel(zDelta, pt))
		Draw();
	return CDialog::OnMouseWheel(nFlags, zDelta, pt);
}

void CPxaEditorBrush::OnMouseMove(UINT nFlags, CPoint point)
{
	view.Select(point);
	if (view.WindowBind_OnMouseMove(point))
		Draw();
	CDialog::OnMouseMove(nFlags, point);
}

void CPxaEditorBrush::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if (view.WindowBind_OnVScroll(nSBCode, nPos))
		Draw();
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CPxaEditorBrush::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if (view.WindowBind_OnHScroll(nSBCode, nPos))
		Draw();
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPxaEditorBrush::UpdateGrid()
{
	if (!tas.pSRV)
		return;
	MyRect rc;
	pRenderer.GetRenderCopyDefaultRect(tas.pSRV, &rc, nullptr);
	float w = rc.GetWidth(), h = rc.GetHeight();
	view.count_w = (int)((int)w % (int)view.grid_w ? w / view.grid_w + 1 : w / view.grid_w);
	int count_h = (int)((int)h % (int)view.grid_h ? h / view.grid_h + 1 : h / view.grid_h);
	view.count_max = view.count_w * count_h;
	Draw();
}
