#include "CPxaEditor.h"
#include "resource.h"
#include "CMainEditor.h"
#include "CPxaEditorGrid.h"

IMPLEMENT_DYNAMIC(CPxaEditor, CDialog)

BEGIN_MESSAGE_MAP(CPxaEditor, CDialog)
	ON_COMMAND(IDOK, &CPxaEditor::OnEnterKey)
	ON_WM_SHOWWINDOW()
	ON_WM_SIZE()
	ON_WM_MOVING()
	ON_COMMAND(ID_EDIT_PXA, &CPxaEditor::OnEditPxa)
	ON_COMMAND(ID_EDIT_PNG, &CPxaEditor::OnEditPng)
	ON_COMMAND(ID_OPEN_FOLDER, &CPxaEditor::OnOpenFolder)
	ON_COMMAND(ID_UPDATE_LIST, &CPxaEditor::OnUpdateList)
	ON_COMMAND(ID_OPEN_FILE, &CPxaEditor::OnOpenFile)
	ON_COMMAND(ID_SAVE_FILE, &CPxaEditor::OnSaveFile)
	ON_COMMAND(ID_CLOSE_FILE, &CPxaEditor::OnCloseFile)
	ON_COMMAND(ID_UNDO, &CPxaEditor::OnUndo)
	ON_COMMAND(ID_REDO, &CPxaEditor::OnRedo)
	ON_COMMAND(ID_COPY, &CPxaEditor::OnCopy)
	ON_COMMAND(ID_PASTE, &CPxaEditor::OnPaste)
	ON_COMMAND(ID_CUT, &CPxaEditor::OnCut)
	ON_COMMAND(ID_SHOW_BK, &CPxaEditor::OnShowBk)
	ON_COMMAND(ID_SHOW_GRID, &CPxaEditor::OnShowGrid)
	ON_COMMAND(ID_GRID_SETTING, &CPxaEditor::OnGridSetting)
	ON_COMMAND(ID_BRUSH_WND, &CPxaEditor::OnBrushWnd)
	ON_COMMAND(ID_RESET_WND_POS, &CPxaEditor::OnResetWndPos)
	ON_LBN_DBLCLK(IDC_LIST_PNGLIST, &CPxaEditor::OnLbnDblclkListPnglist)
END_MESSAGE_MAP()

CPxaEditor::CPxaEditor(CWnd* pParent)
	: CDialog(IDD_CPXAEDITOR, pParent)
{
}

CPxaEditor::~CPxaEditor()
{
}

void CPxaEditor::Draw()
{
	pDrawWnd.Draw();
}

void CPxaEditor::Load(CString filename)
{
	saved.clear();
	undoRedo.Clear();
	//ȡļ
	pngfile = filename;
	CString str = filename;
	str = str.Left(filename.ReverseFind(L'.'));
	str.Append(L".pxa");
	pxafile = str;
	//Ӵ
	pDrawWnd.Load(pngfile);
	//ļ
	FILE* fp;
	_wfopen_s(&fp, pxafile.GetString(), L"rb");
	if (fp)
	{
		fseek(fp, 0, SEEK_END);
		size_t fileLen = ftell(fp);
		fseek(fp, 0, SEEK_SET);
		std::vector<BYTE> cbuff;
		cbuff.resize(fileLen);
		fread_s(cbuff.data(), fileLen, fileLen, 1, fp);
		fclose(fp);
		std::vector<BYTE> byte_buff;
		size_t len = 0;
		ZLibUncompressData(&byte_buff, &len, cbuff.data(), fileLen);
		CString xml = (wchar_t*)byte_buff.data();
		XMLLoad(xml);//ȡpxa
		//ֵ
		StepCopyToSaved();
	}
	else
		Save();
	UpdateMenuState();//³˵״̬
	UpdateWindowTitle();//´ڱ
	Draw();
}

void CPxaEditor::StaticLoad(CString pxaName, CPXAEDITOR_DATATYPE_PXA* pxaList, int* outTileW, int* outTileH, bool* outInterArea)
{
	CString pxafile;
	pxafile.Format(L"./data/pxa/%s.pxa", pxaName.GetString());
	pxaList->clear();
	//ļ
	FILE* fp;
	_wfopen_s(&fp, pxafile.GetString(), L"rb");
	if (fp)
	{
		fseek(fp, 0, SEEK_END);
		size_t fileLen = ftell(fp);
		fseek(fp, 0, SEEK_SET);
		std::vector<BYTE> cbuff;
		cbuff.resize(fileLen);
		fread_s(cbuff.data(), fileLen, fileLen, 1, fp);
		fclose(fp);
		std::vector<BYTE> byte_buff;
		size_t len = 0;
		ZLibUncompressData(&byte_buff, &len, cbuff.data(), fileLen);
		CString xml = (wchar_t*)byte_buff.data();
		StaticXMLLoad(xml, pxaList, outTileW, outTileH, outInterArea);//ȡpxa
	}
	else
	{
		//ļʹnullpxa
		*outTileW = 16;
		*outTileH = 16;
	}
}

void CPxaEditor::Save()
{
	StepCopyToSaved();
	CString xml = XMLSaved();//дpid
	//ѹ
	std::vector<BYTE> compressData;
	size_t compressData_len;
	ZLibCompressData(&compressData, &compressData_len, xml.GetString(), ((size_t)xml.GetLength() + 1) * sizeof(wchar_t));//\0
	//ļд
	FILE* fp = nullptr;
	_wfopen_s(&fp, pxafile.GetString(), L"wb+");
	if (!fp)
	{
		CString err;
		err.Format(L"д%sʧ\nļڱռ", pxafile.GetString());
		MessageBox(err.GetString(), L"ļдʧ", MB_ICONINFORMATION);
		return;
	}
	fwrite(compressData.data(), compressData_len, 1, fp);
	fclose(fp);
	//´ڱ
	UpdateWindowTitle();
}

bool CPxaEditor::Close()
{
	if (!IsLoaded())
		return false;
	if (!CheckSaved())//δ
	{
		switch (MessageBox(TEXT("Ҫ޸ĵ"), TEXT("޸ĵݼʧ"), MB_YESNOCANCEL | MB_ICONWARNING))
		{
		case IDYES:
			Save();
		case IDNO:
			break;
		case IDCANCEL:
			return true;
		}
	}
	ResetContext();
	return false;
}

CPXAEDITOR_DATATYPE_PXA* CPxaEditor::GetStep()
{
	return (CPXAEDITOR_DATATYPE_PXA*)undoRedo.GetStep(CPXAEDITOR_DATATYPE_PXA_STR);
}

void CPxaEditor::UpdateMenuState()
{
	if (undoRedo.UndoEmpty())
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_UNDO, MF_DISABLED);
	else
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_UNDO, MF_ENABLED);
	if (undoRedo.RedoEmpty())
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_REDO, MF_DISABLED);
	else
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_REDO, MF_ENABLED);
	if (IsLoaded())
	{
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_FILE)->EnableMenuItem(ID_SAVE_FILE, MF_ENABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_FILE)->EnableMenuItem(ID_CLOSE_FILE, MF_ENABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_COPY, MF_ENABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_PASTE, MF_ENABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_CUT, MF_ENABLED);
	}
	else
	{
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_FILE)->EnableMenuItem(ID_SAVE_FILE, MF_DISABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_FILE)->EnableMenuItem(ID_CLOSE_FILE, MF_DISABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_COPY, MF_DISABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_PASTE, MF_DISABLED);
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_EDIT)->EnableMenuItem(ID_CUT, MF_DISABLED);
	}
}

void CPxaEditor::UpdateWindowTitle()
{
	CString windowTitle, appendStr;
	bool sav = CheckSaved();
	auto& view = *pDrawWnd.GetMyView();

	appendStr.Format(TEXT("α༭ - "));
	windowTitle.Append(appendStr);
	if (view.cursorX_selected == 0 && view.cursorY_selected == 0)
		appendStr.Format(TEXT("δѡκε - "));
	else
		appendStr.Format(TEXT("ǰѡеĵΣ(%d,%d) - "), view.cursorX_selected, view.cursorY_selected);
	windowTitle.Append(appendStr);
	if (IsLoaded())
	{
		appendStr.Format(TEXT("ļ%s"), pxafile.GetString());
		windowTitle.Append(appendStr);
		if (!sav)
			windowTitle.Append(TEXT("(δ)"));
		else
			windowTitle.Append(TEXT("(ѱ)"));
	}
	else
	{
		windowTitle.Append(TEXT("(δļ)"));
	}
	SetWindowText(windowTitle);
}

bool CPxaEditor::CheckSaved()
{
	auto& step = *GetStep();
	//ųЧidĸĶ
	CPXAEDITOR_DATATYPE_PXA l, r;
	for (auto& p : saved)
	{
		if (p.first == 0 ||
			p.second == 0)
			continue;
		l.insert(p);
	}
	for (auto& p : step)
	{
		if (p.first == 0 ||
			p.second == 0)
			continue;
		r.insert(p);
	}
	//
	bool bPxaTile = (pxa_tile_w_saved == (int)(*pPxa_tile_w) &&
		pxa_tile_h_saved == (int)(*pPxa_tile_h)) &&
		bInterArea_saved == bInterArea;
	return l == r && bPxaTile;
}

bool CPxaEditor::IsLoaded()
{
	return pxafile.GetLength() > 0;
}

void CPxaEditor::ResetContext()
{
	pxafile = L"";
	pngfile = L"";
	saved.clear();
	undoRedo.Clear();
	pDrawWnd.ResetContext();
	//³˵״̬
	UpdateMenuState();
	//´ڱ
	UpdateWindowTitle();
}

void CPxaEditor::XMLLoad(CString xml)
{
	std::vector<char> utf8_buff;
	UTF16ToUTF8(xml.GetString(), &utf8_buff);
	tinyxml2::XMLDocument xmlDoc;
	xmlDoc.Parse(utf8_buff.data());
	tinyxml2::XMLElement* elem = nullptr;
	//ѰTileSetԪ
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "TileSet"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem)
	{
		//ȡTileSet
		*pPxa_tile_w = (float)elem->IntAttribute("TileW");
		*pPxa_tile_h = (float)elem->IntAttribute("TileH");
		bInterArea = elem->BoolAttribute("InterArea");
		pDrawWnd.UpdateGrid();
	}
	//ѰPxaԪ
	elem = nullptr;
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Pxa"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem == nullptr)
	{
		CString err;
		err.Format(L"ļ%sҲPxaԪ", pxafile.GetString());
		MessageBox(err.GetString(), L"ļ", MB_ICONWARNING);
		return;
	}
	//еIDԪ
	for (elem = elem->FirstChildElement(); elem; elem = elem->NextSiblingElement())
	{
		//RectԪ
		if (strcmp(elem->Name(), "ID"))
			continue;
		//stepֵ
		auto& step = *((CPXAEDITOR_DATATYPE_PXA*)undoRedo.GetStep(CPXAEDITOR_DATATYPE_PXA_STR));
		int x = elem->IntAttribute("x");
		int y = elem->IntAttribute("y");
		int pxa = elem->IntAttribute("pxa");
		step[MAKELONG(x, y)] = pxa;
	}
}

void CPxaEditor::StaticXMLLoad(CString xml, CPXAEDITOR_DATATYPE_PXA* pxaList, int* outTileW, int* outTileH, bool* outInterArea)
{
	std::vector<char> utf8_buff;
	UTF16ToUTF8(xml.GetString(), &utf8_buff);
	tinyxml2::XMLDocument xmlDoc;
	xmlDoc.Parse(utf8_buff.data());
	tinyxml2::XMLElement* elem = nullptr;
	//ѰTileSetԪ
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "TileSet"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem)
	{
		//ȡTileSet
		*outTileW = elem->IntAttribute("TileW");
		*outTileH = elem->IntAttribute("TileH");
		if (outInterArea)
			*outInterArea = elem->BoolAttribute("InterArea");
	}
	//ѰPxaԪ
	elem = nullptr;
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Pxa"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem == nullptr)
	{
		CString err;
		err.Format(L"xmlҲPxaԪ");
		::MessageBox(nullptr, err.GetString(), L"ļ", MB_ICONWARNING);
		return;
	}
	//еIDԪ
	for (elem = elem->FirstChildElement(); elem; elem = elem->NextSiblingElement())
	{
		//RectԪ
		if (strcmp(elem->Name(), "ID"))
			continue;
		//stepֵ
		auto& step = *pxaList;
		int x = elem->IntAttribute("x");
		int y = elem->IntAttribute("y");
		int pxa = elem->IntAttribute("pxa");
		step[MAKELONG(x, y)] = pxa;
	}
}

MyUndoRedo* CPxaEditor::GetMyUndoRedo()
{
	return &undoRedo;
}

CString CPxaEditor::XMLSaved()
{
	//дxmlļ
	tinyxml2::XMLDocument xmlDoc;
	//дTileSetԪ
	auto elem_tileSet = xmlDoc.NewElement("TileSet");
	elem_tileSet->SetAttribute("TileW", (int)(*pPxa_tile_w));
	elem_tileSet->SetAttribute("TileH", (int)(*pPxa_tile_h));
	elem_tileSet->SetAttribute("InterArea", bInterArea);
	xmlDoc.InsertEndChild(elem_tileSet);
	//дPxaԪ
	auto elem_pxa = xmlDoc.NewElement("Pxa");
	xmlDoc.InsertEndChild(elem_pxa);
	//дPxa
	for (auto& p : saved)
	{
		if (p.first == 0 ||
			p.second == 0)
			continue;
		auto y = (int)HIWORD(p.first);
		auto x = (int)LOWORD(p.first);

		auto elem_tile = xmlDoc.NewElement("ID");
		elem_tile->SetAttribute("x", x);
		elem_tile->SetAttribute("y", y);
		elem_tile->SetAttribute("pxa", p.second);
		elem_pxa->InsertEndChild(elem_tile);
	}
	//дļ
	tinyxml2::XMLPrinter xmlPrinter;
	xmlDoc.Print(&xmlPrinter);
	std::vector<wchar_t> wchar_buff;
	UTF8ToUTF16(xmlPrinter.CStr(), &wchar_buff);
	return CString(wchar_buff.data());
}

void CPxaEditor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	static_pxaList = (CStatic*)GetDlgItem(IDC_STATIC_PXALIST);
	DDX_Control(pDX, IDC_LIST_PNGLIST, listbox_pxaList);
	static_pxaEditor = (CStatic*)GetDlgItem(IDC_STATIC_PXAEDITOR);
}

int CPxaEditor::GetSelectPxaValue()
{
	auto& view = *pBrushWnd.GetMyView();
	return view.cursorX_selected + view.cursorY_selected * view.count_w;
}

void* CPxaEditor_Pxa_NewData()
{
	return new CPXAEDITOR_DATATYPE_PXA();
}
void* CPxaEditor_Pxa_NewCopyOfData(void* data)
{
	CPXAEDITOR_DATATYPE_PXA* pStep = (CPXAEDITOR_DATATYPE_PXA*)data;
	CPXAEDITOR_DATATYPE_PXA* pNewStep = new CPXAEDITOR_DATATYPE_PXA();
	*pNewStep = *pStep;
	return pNewStep;
}
void CPxaEditor_Pxa_ReleaseData(void* data)
{
	CPXAEDITOR_DATATYPE_PXA* pStep = (CPXAEDITOR_DATATYPE_PXA*)data;
	delete pStep;
}

BOOL CPxaEditor::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ݼ
	LOADHOTKEY(IDR_ACC_PIDEDITOR);
	//Ӧóͼ
	auto hIcon = AfxGetApp()->LoadIcon(IDI_ICON_PXA);
	SetIcon(hIcon, true);
	//ó
	MyUndoRedoDataOp op_pid;
	op_pid.NewData = CPxaEditor_Pxa_NewData;
	op_pid.NewCopyOfData = CPxaEditor_Pxa_NewCopyOfData;
	op_pid.ReleaseData = CPxaEditor_Pxa_ReleaseData;
	undoRedo.AddDataType(CPXAEDITOR_DATATYPE_PXA_STR, op_pid);
	//listbox_pxaList
	listbox_pxaList.SetMenu(IDR_CPXAEDITOR_RMENU, IDR_CPXAEDITOR_RMENU_NOSEL);
	//ʼӴ
	pDrawWnd.pParentEditor = this;
	pDrawWnd.Create(IDD_CPXAEDITOR_DRAW, this);
	pDrawWnd.ShowWindow(SW_SHOW);
	pBrushWnd.pParentEditor = this;
	pBrushWnd.Create(IDD_CPXAEDITOR_BRUSH, this);
	//óʼ
	pPxa_tile_w = &pDrawWnd.GetMyView()->grid_w;
	pPxa_tile_h = &pDrawWnd.GetMyView()->grid_h;
	showGrid = false;
	OnShowGrid();//
	showBk = false;
	OnShowBk();//͸
	//б
	OnUpdateList();
	//ôλ
	OnResetWndPos();
	//³˵״̬
	UpdateMenuState();
	//´ڱ
	UpdateWindowTitle();
	return 0;
}

MyView* CPxaEditor::GetBrushView()
{
	return pBrushWnd.GetMyView();
}

void CPxaEditor::OnCancel()
{
	if (Close())
		return;
	ShowWindow(SW_HIDE);
}

void CPxaEditor::OnEnterKey()
{
}

void CPxaEditor::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);
	auto mainEditor = (CMainEditor*)pMainEditor;
	if (bShow)
	{
		pBrushWnd.ShowWindow(SW_SHOW);
		mainEditor->GetMenu()->GetSubMenu(CMAINEDITOR_MENUINDEX_GAMEEDITOR)->CheckMenuItem(ID_PXA_EDITOR, MF_BYCOMMAND | MF_CHECKED);
	}
	else
	{
		pBrushWnd.ShowWindow(SW_HIDE);
		mainEditor->GetMenu()->GetSubMenu(CMAINEDITOR_MENUINDEX_GAMEEDITOR)->CheckMenuItem(ID_PXA_EDITOR, MF_BYCOMMAND | MF_UNCHECKED);
	}
}

BOOL CPxaEditor::PreTranslateMessage(MSG* pMsg)
{
	HOTKEYPROC;
}

void CPxaEditor::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if (!static_pxaList)
		return;
	auto dpi = MyGetDPI();
	//ͼб
	int x, y, w, h;
	x = DPISCALE(10);
	y = DPISCALE(10);
	w = DPISCALE(200);
	h = cy - DPISCALE(20);
	static_pxaList->MoveWindow(x, y, w, h);
	y += DPISCALE(20);
	h -= DPISCALE(20);
	listbox_pxaList.MoveWindow(x, y, w, h);
	//ID༭
	x = DPISCALE(220);
	y = DPISCALE(10);
	w = cx - DPISCALE(230);
	h = cy - DPISCALE(20);
	static_pxaEditor->MoveWindow(x, y, w, h);
	y += DPISCALE(20);
	h -= DPISCALE(20);
	w -= DPISCALE(1);
	pDrawWnd.MoveWindow(x, y, w, h);
}

void CPxaEditor::OnMoving(UINT fwSide, LPRECT pRect)
{
	CDialog::OnMoving(fwSide, pRect);
	OnResetWndPos();
}


void CPxaEditor::OnEditPxa()
{
	if (Close())
		return;
	int sel = listbox_pxaList.GetCurSel();
	CString name;
	listbox_pxaList.GetText(sel, name);
	CString filename;
	filename.Format(L"./data/pxa/%s", name.GetString());
	Load(filename);
}


void CPxaEditor::OnEditPng()
{
	int selIndex = listbox_pxaList.GetCurSel();
	if (selIndex < 0)
		return;
	wchar_t buff[MAX_PATH];
	CString filepath;
	GetModuleFileNameW(nullptr, buff, _countof(buff));
	filepath = buff;
	auto index = filepath.ReverseFind(L'\\');
	filepath.Delete(index, filepath.GetLength() - index);
	filepath.Append(L"\\data\\pxa\\");
	CString pngfile;

	listbox_pxaList.GetText(selIndex, pngfile);
	filepath.Append(pngfile);

	CString cmd;
	cmd.Format(L"explorer \"%s\"", filepath.GetString());
	MyWinExec(cmd.GetString());
}


void CPxaEditor::OnOpenFolder()
{
	std::vector<char> utf8_buff;
	wchar_t buff[MAX_PATH];
	CString filepath;
	GetModuleFileNameW(nullptr, buff, _countof(buff));
	filepath = buff;
	auto index = filepath.ReverseFind(L'\\');
	filepath.Delete(index, filepath.GetLength() - index);
	filepath.Append(L"\\data\\pxa\\");

	CString cmd;
	index = listbox_pxaList.GetCurSel();
	if (index >= 0)
	{
		CString pngfile;
		listbox_pxaList.GetText(index, pngfile);
		filepath.Append(pngfile);
		cmd.Format(L"explorer /select,%s", filepath.GetString());
	}
	else
	{
		cmd.Format(L"explorer %s", filepath.GetString());
	}
	MyWinExec(cmd.GetString());
}


void CPxaEditor::OnUpdateList()
{
	
	listbox_pxaList.ResetContent();

	CFileFind finder;
	bool rs = finder.FindFile(L"./data/pxa/*.webp");
	while (rs)
	{
		rs = finder.FindNextFile();
		CString str = finder.GetFileName();
		listbox_pxaList.AddString(str);
	}
}


void CPxaEditor::OnOpenFile()
{
	
	if (Close())
		return;
	wchar_t buff[MAX_PATH];
	CString filepath;
	GetModuleFileNameW(nullptr, buff, _countof(buff));
	filepath = buff;
	auto index = filepath.ReverseFind(L'\\');
	filepath.Delete(index, filepath.GetLength() - index);
	filepath.Append(L"\\data\\pxa\\");
	CFileDialog fd(TRUE, TEXT(""), TEXT(""), OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, TEXT("ͼļ(*.png)|*.png|ļ(*.*)|*.*||"), this);
	fd.m_ofn.lpstrInitialDir = filepath.GetString();
	if (fd.DoModal() != IDOK)
		return;
	Load(fd.GetPathName());
	UpdateMenuState();
	UpdateWindowTitle();
}


void CPxaEditor::OnSaveFile()
{
	
	if (!IsLoaded())
		return;
	Save();
}


void CPxaEditor::OnCloseFile()
{
	Close();
}


void CPxaEditor::OnUndo()
{
	undoRedo.Undo();
	UpdateMenuState();
	UpdateWindowTitle();
	Draw();
}


void CPxaEditor::OnRedo()
{
	undoRedo.Redo();
	UpdateMenuState();
	UpdateWindowTitle();
	Draw();
}


void CPxaEditor::OnCopy()
{
	if (!IsLoaded())
		return;
	pxaCopy = pDrawWnd.GetCopyPxa();
}


void CPxaEditor::OnPaste()
{
	if (!IsLoaded())
		return;
	pDrawWnd.SetCopyPxa(pxaCopy);
	UpdateMenuState();
	UpdateWindowTitle();
	Draw();
}


void CPxaEditor::OnCut()
{
	if (!IsLoaded())
		return;
	pxaCopy = pDrawWnd.GetCopyPxa();
	pDrawWnd.SetCopyPxa(0);
	UpdateMenuState();
	UpdateWindowTitle();
	Draw();
}


void CPxaEditor::OnShowBk()
{
	
	if (showBk)
	{
		showBk = false;
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_OPTION)->CheckMenuItem(ID_SHOW_BK, MF_BYCOMMAND | MF_UNCHECKED);
	}
	else
	{
		showBk = true;
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_OPTION)->CheckMenuItem(ID_SHOW_BK, MF_BYCOMMAND | MF_CHECKED);
	}
	Draw();
}


void CPxaEditor::OnShowGrid()
{
	
	if (showGrid)
	{
		showGrid = false;
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_OPTION)->CheckMenuItem(ID_SHOW_GRID, MF_BYCOMMAND | MF_UNCHECKED);
	}
	else
	{
		showGrid = true;
		GetMenu()->GetSubMenu(CPXAEDITOR_MENUINDEX_OPTION)->CheckMenuItem(ID_SHOW_GRID, MF_BYCOMMAND | MF_CHECKED);
	}
	Draw();
}


void CPxaEditor::OnGridSetting()
{
	CPxaEditorGrid dlg;
	dlg.outGridW = (int)(*pPxa_tile_w);
	dlg.outGridH = (int)(*pPxa_tile_h);
	dlg.outInterArea = bInterArea;
	if (dlg.DoModal() != IDOK)
		return;
	*pPxa_tile_w = (float)dlg.outGridW;
	*pPxa_tile_h = (float)dlg.outGridH;
	bInterArea = dlg.outInterArea;
	pDrawWnd.UpdateGrid();
	UpdateWindowTitle();
}


void CPxaEditor::OnBrushWnd()
{
	pBrushWnd.ShowWindow(pBrushWnd.IsWindowVisible() ? SW_HIDE : SW_SHOW);
}


void CPxaEditor::OnResetWndPos()
{
	CRect rcDst, rcSrc;
	GetWindowRect(rcDst);
	pBrushWnd.GetWindowRect(rcSrc);
	MoveToNeighborRect(rcDst, rcSrc, 1, 0);
	::MoveWindow(&pBrushWnd, rcSrc.left, rcSrc.top);
}

void CPxaEditor::OnLbnDblclkListPnglist()
{
	int selIndex = listbox_pxaList.GetCurSel();
	if (selIndex < 0)
		return;
	OnEditPxa();
}

void CPxaEditor::StepCopyToSaved()
{
	saved = *((CPXAEDITOR_DATATYPE_PXA*)undoRedo.GetStep(CPXAEDITOR_DATATYPE_PXA_STR));
	pxa_tile_w_saved = (int)(*pPxa_tile_w);
	pxa_tile_h_saved = (int)(*pPxa_tile_h);
	bInterArea_saved = bInterArea;
}
